/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.ctx;

import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.Indenter;
import org.wso2.balana.ParsingException;
import org.wso2.balana.PolicyMetaData;
import org.wso2.balana.UnknownIdentifierException;
import org.wso2.balana.attr.AttributeFactory;
import org.wso2.balana.attr.AttributeValue;
import org.wso2.balana.attr.DateTimeAttribute;

public class Attribute {
    private URI id;
    private URI type;
    private boolean includeInResult;
    private String issuer = null;
    private DateTimeAttribute issueInstant = null;
    private AttributeValue value;
    private int xacmlVersion;

    public Attribute(URI id, String issuer, DateTimeAttribute issueInstant, AttributeValue value, boolean includeInResult) {
        this(id, value.getType(), issuer, issueInstant, value, includeInResult, 0);
    }

    public Attribute(URI id, String issuer, DateTimeAttribute issueInstant, AttributeValue value) {
        this(id, value.getType(), issuer, issueInstant, value, false, 0);
    }

    public Attribute(URI id, URI type, String issuer, DateTimeAttribute issueInstant, AttributeValue value, boolean includeInResult, int xacmlVersion) {
        this.id = id;
        this.type = type;
        this.issuer = issuer;
        this.issueInstant = issueInstant;
        this.value = value;
        this.includeInResult = includeInResult;
        this.xacmlVersion = xacmlVersion;
    }

    public static Attribute getInstance(Node root) throws ParsingException {
        return Attribute.getInstance(root, new PolicyMetaData());
    }

    public static Attribute getInstance(Node root, PolicyMetaData metaData) throws ParsingException {
        URI id = null;
        URI type = null;
        String issuer = null;
        DateTimeAttribute issueInstant = null;
        AttributeValue value = null;
        boolean includeInResult = false;
        int version = metaData.getXACMLVersion();
        AttributeFactory attrFactory = AttributeFactory.getInstance();
        if (!root.getNodeName().equals("Attribute")) {
            throw new ParsingException("Attribute object cannot be created with root node of type: " + root.getNodeName());
        }
        NamedNodeMap attrs = root.getAttributes();
        try {
            id = new URI(attrs.getNamedItem("AttributeId").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required attribute AttributeId in AttributeType", e);
        }
        if (version != 3) {
            try {
                type = new URI(attrs.getNamedItem("DataType").getNodeValue());
            }
            catch (Exception e) {
                throw new ParsingException("Error parsing required attribute DataType in AttributeType", e);
            }
        }
        if (version == 3) {
            try {
                String includeInResultString = attrs.getNamedItem("IncludeInResult").getNodeValue();
                if ("true".equals(includeInResultString)) {
                    includeInResult = true;
                }
            }
            catch (Exception e) {
                throw new ParsingException("Error parsing required attribute IncludeInResult in AttributeType", e);
            }
        }
        try {
            Node instantNode;
            Node issuerNode = attrs.getNamedItem("Issuer");
            if (issuerNode != null) {
                issuer = issuerNode.getNodeValue();
            }
            if (version != 3 && (instantNode = attrs.getNamedItem("IssueInstant")) != null) {
                issueInstant = DateTimeAttribute.getInstance(instantNode.getNodeValue());
            }
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing optional AttributeType attribute", e);
        }
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!node.getNodeName().equals("AttributeValue")) continue;
            if (value != null) {
                throw new ParsingException("Too many values in Attribute");
            }
            if (version == 3) {
                NamedNodeMap dataTypeAttribute = node.getAttributes();
                try {
                    type = new URI(dataTypeAttribute.getNamedItem("DataType").getNodeValue());
                }
                catch (Exception e) {
                    throw new ParsingException("Error parsing required attribute DataType in AttributeType", e);
                }
            }
            try {
                value = attrFactory.createValue(node, type);
                continue;
            }
            catch (UnknownIdentifierException uie) {
                throw new ParsingException("Unknown AttributeId", uie);
            }
        }
        if (value == null) {
            throw new ParsingException("Attribute must contain a value");
        }
        return new Attribute(id, type, issuer, issueInstant, value, includeInResult, version);
    }

    public URI getId() {
        return this.id;
    }

    public URI getType() {
        return this.type;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public DateTimeAttribute getIssueInstant() {
        return this.issueInstant;
    }

    public boolean isIncludeInResult() {
        return this.includeInResult;
    }

    public AttributeValue getValue() {
        return this.value;
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        String indent = indenter.makeString();
        PrintStream out = new PrintStream(output);
        out.println(indent + this.encode());
    }

    public String encode() {
        String encoded = "<Attribute AttributeId=\"" + this.id.toString() + "\"";
        if (this.xacmlVersion == 3) {
            encoded = encoded + " IncludeInResult=\"" + this.includeInResult + "\"";
        } else {
            encoded = encoded + " DataType=\"" + this.type.toString() + "\"";
            if (this.issueInstant != null) {
                encoded = encoded + " IssueInstant=\"" + this.issueInstant.encode() + "\"";
            }
        }
        if (this.issuer != null) {
            encoded = encoded + " Issuer=\"" + this.issuer + "\"";
        }
        encoded = encoded + ">" + this.value.encodeWithTags(false) + "</Attribute>";
        return encoded;
    }
}

