/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.cond;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.wso2.balana.attr.AttributeValue;
import org.wso2.balana.attr.BagAttribute;
import org.wso2.balana.cond.EvaluationResult;
import org.wso2.balana.cond.SetFunction;
import org.wso2.balana.ctx.EvaluationCtx;

public class GeneralSetFunction
extends SetFunction {
    private static final int ID_BASE_INTERSECTION = 0;
    private static final int ID_BASE_UNION = 1;
    private static HashMap<String, Integer> idMap;
    private static HashMap<String, String> typeMap;

    public GeneralSetFunction(String functionName) {
        super(functionName, GeneralSetFunction.getId(functionName), GeneralSetFunction.getArgumentType(functionName), GeneralSetFunction.getArgumentType(functionName), true);
    }

    public GeneralSetFunction(String functionName, String datatype, String functionType) {
        super(functionName, GeneralSetFunction.getId(functionType), datatype, datatype, true);
    }

    private static int getId(String functionName) {
        Integer id = idMap.get(functionName);
        if (id == null) {
            throw new IllegalArgumentException("unknown set function " + functionName);
        }
        return id;
    }

    private static String getArgumentType(String functionName) {
        return typeMap.get(functionName);
    }

    public static Set getSupportedIdentifiers() {
        return Collections.unmodifiableSet(idMap.keySet());
    }

    public EvaluationResult evaluate(List inputs, EvaluationCtx context) {
        AttributeValue[] argValues = new AttributeValue[inputs.size()];
        EvaluationResult evalResult = this.evalArgs(inputs, context, argValues);
        if (evalResult != null) {
            return evalResult;
        }
        BagAttribute[] bags = new BagAttribute[]{(BagAttribute)argValues[0], (BagAttribute)argValues[1]};
        BagAttribute result = null;
        HashSet<AttributeValue> set = new HashSet<AttributeValue>();
        switch (this.getFunctionId()) {
            case 0: {
                Iterator it = bags[0].iterator();
                while (it.hasNext()) {
                    AttributeValue value = (AttributeValue)it.next();
                    if (!bags[1].contains(value)) continue;
                    set.add(value);
                }
                result = new BagAttribute(bags[0].getType(), set);
                break;
            }
            case 1: {
                Iterator it0 = bags[0].iterator();
                while (it0.hasNext()) {
                    set.add((AttributeValue)it0.next());
                }
                Iterator it1 = bags[1].iterator();
                while (it1.hasNext()) {
                    set.add((AttributeValue)it1.next());
                }
                result = new BagAttribute(bags[0].getType(), set);
            }
        }
        return new EvaluationResult(result);
    }

    static {
        String baseType;
        String baseName;
        int i;
        idMap = new HashMap();
        typeMap = new HashMap();
        idMap.put("-intersection", 0);
        idMap.put("-union", 1);
        for (i = 0; i < baseTypes.length; ++i) {
            baseName = "urn:oasis:names:tc:xacml:1.0:function:" + simpleTypes[i];
            baseType = baseTypes[i];
            idMap.put(baseName + "-intersection", 0);
            idMap.put(baseName + "-union", 1);
            typeMap.put(baseName + "-intersection", baseType);
            typeMap.put(baseName + "-union", baseType);
        }
        for (i = 0; i < baseTypes2.length; ++i) {
            baseName = "urn:oasis:names:tc:xacml:2.0:function:" + simpleTypes2[i];
            baseType = baseTypes2[i];
            idMap.put(baseName + "-intersection", 0);
            idMap.put(baseName + "-union", 1);
            typeMap.put(baseName + "-intersection", baseType);
            typeMap.put(baseName + "-union", baseType);
        }
    }
}

