/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.combine;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.balana.UnknownIdentifierException;
import org.wso2.balana.combine.BaseCombiningAlgFactory;
import org.wso2.balana.combine.CombiningAlgFactory;
import org.wso2.balana.combine.CombiningAlgorithm;
import org.wso2.balana.combine.DenyOverridesPolicyAlg;
import org.wso2.balana.combine.DenyOverridesRuleAlg;
import org.wso2.balana.combine.FirstApplicablePolicyAlg;
import org.wso2.balana.combine.FirstApplicableRuleAlg;
import org.wso2.balana.combine.OnlyOneApplicablePolicyAlg;
import org.wso2.balana.combine.OrderedDenyOverridesPolicyAlg;
import org.wso2.balana.combine.OrderedDenyOverridesRuleAlg;
import org.wso2.balana.combine.OrderedPermitOverridesPolicyAlg;
import org.wso2.balana.combine.OrderedPermitOverridesRuleAlg;
import org.wso2.balana.combine.PermitOverridesPolicyAlg;
import org.wso2.balana.combine.PermitOverridesRuleAlg;

public class StandardCombiningAlgFactory
extends BaseCombiningAlgFactory {
    private static StandardCombiningAlgFactory factoryInstance = null;
    private static Set supportedAlgorithms = null;
    private static Set supportedAlgIds;
    private static Log logger;

    private StandardCombiningAlgFactory() {
        super(supportedAlgorithms);
    }

    private static void initAlgorithms() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Initializing standard combining algorithms");
        }
        supportedAlgorithms = new HashSet();
        supportedAlgIds = new HashSet();
        supportedAlgorithms.add(new DenyOverridesRuleAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:deny-overrides");
        supportedAlgorithms.add(new DenyOverridesPolicyAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:deny-overrides");
        supportedAlgorithms.add(new OrderedDenyOverridesRuleAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:1.1:rule-combining-algorithm:ordered-deny-overrides");
        supportedAlgorithms.add(new OrderedDenyOverridesPolicyAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:1.1:policy-combining-algorithm:ordered-deny-overrides");
        supportedAlgorithms.add(new PermitOverridesRuleAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:permit-overrides");
        supportedAlgorithms.add(new PermitOverridesPolicyAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:permit-overrides");
        supportedAlgorithms.add(new OrderedPermitOverridesRuleAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:1.1:rule-combining-algorithm:ordered-permit-overrides");
        supportedAlgorithms.add(new OrderedPermitOverridesPolicyAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:1.1:policy-combining-algorithm:ordered-permit-overrides");
        supportedAlgorithms.add(new FirstApplicableRuleAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:first-applicable");
        supportedAlgorithms.add(new FirstApplicablePolicyAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:first-applicable");
        supportedAlgorithms.add(new OnlyOneApplicablePolicyAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:only-one-applicable");
        supportedAlgIds = Collections.unmodifiableSet(supportedAlgIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StandardCombiningAlgFactory getFactory() {
        if (factoryInstance != null) return factoryInstance;
        Class<StandardCombiningAlgFactory> clazz = StandardCombiningAlgFactory.class;
        synchronized (StandardCombiningAlgFactory.class) {
            if (factoryInstance != null) return factoryInstance;
            StandardCombiningAlgFactory.initAlgorithms();
            factoryInstance = new StandardCombiningAlgFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return factoryInstance;
        }
    }

    public static CombiningAlgFactory getNewFactory() {
        StandardCombiningAlgFactory.getFactory();
        return new BaseCombiningAlgFactory(supportedAlgorithms);
    }

    public static Set getStandardAlgorithms(String xacmlVersion) throws UnknownIdentifierException {
        if (xacmlVersion.equals("urn:oasis:names:tc:xacml:1.0:policy") || xacmlVersion.equals("urn:oasis:names:tc:xacml:2.0:policy:schema:os")) {
            return supportedAlgIds;
        }
        throw new UnknownIdentifierException("Unknown XACML version: " + xacmlVersion);
    }

    public void addAlgorithm(CombiningAlgorithm alg) {
        throw new UnsupportedOperationException("a standard factory cannot support new algorithms");
    }

    static {
        logger = LogFactory.getLog(StandardCombiningAlgFactory.class);
    }
}

