/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana;

import org.wso2.balana.attr.AttributeFactory;
import org.wso2.balana.attr.AttributeFactoryProxy;
import org.wso2.balana.combine.CombiningAlgFactory;
import org.wso2.balana.combine.CombiningAlgFactoryProxy;
import org.wso2.balana.cond.FunctionFactory;
import org.wso2.balana.cond.FunctionFactoryProxy;

public class PolicyMetaData {
    public static final int XACML_DEFAULT_VERSION = 0;
    private static String[] xacmlIdentifiers = new String[]{"urn:oasis:names:tc:xacml:1.0:policy", "urn:oasis:names:tc:xacml:1.0:policy", "urn:oasis:names:tc:xacml:2.0:policy:schema:os", "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17"};
    public static final String XPATH_1_0_IDENTIFIER = "http://www.w3.org/TR/1999/Rec-xpath-19991116";
    public static final int XPATH_VERSION_UNSPECIFIED = 0;
    public static final int XPATH_VERSION_1_0 = 1;
    private static String[] xpathIdentifiers = new String[]{null, "http://www.w3.org/TR/1999/Rec-xpath-19991116"};
    private int xacmlVersion;
    private int xpathVersion;
    private AttributeFactoryProxy afProxy;
    private CombiningAlgFactoryProxy cafProxy;
    private FunctionFactoryProxy ffProxy;

    public PolicyMetaData() {
        this(0, 0);
    }

    public PolicyMetaData(int xacmlVersion, int xpathVersion) {
        this(xacmlVersion, xpathVersion, null, null, null);
    }

    public PolicyMetaData(String xacmlVersion, String xpathVersion) {
        this(xacmlVersion, xpathVersion, null, null, null);
    }

    public PolicyMetaData(int xacmlVersion, int xpathVersion, AttributeFactoryProxy attributeFactoryProxy, CombiningAlgFactoryProxy combiningAlgFactoryProxy, FunctionFactoryProxy functionFactoryProxy) {
        this.xacmlVersion = xacmlVersion;
        this.xpathVersion = xpathVersion;
        this.proxySetup(attributeFactoryProxy, combiningAlgFactoryProxy, functionFactoryProxy);
    }

    public PolicyMetaData(String xacmlVersion, String xpathVersion, AttributeFactoryProxy attributeFactoryProxy, CombiningAlgFactoryProxy combiningAlgFactoryProxy, FunctionFactoryProxy functionFactoryProxy) {
        if (xacmlVersion == null) {
            this.xacmlVersion = 0;
        } else if (xacmlVersion.equals("urn:oasis:names:tc:xacml:1.0:policy")) {
            this.xacmlVersion = 0;
        } else if (xacmlVersion.equals("urn:oasis:names:tc:xacml:2.0:policy:schema:os")) {
            this.xacmlVersion = 2;
        } else if (xacmlVersion.equals("urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
            this.xacmlVersion = 3;
        } else {
            throw new IllegalArgumentException("Unknown XACML version string: " + xacmlVersion);
        }
        if (xpathVersion != null) {
            if (!xpathVersion.equals(XPATH_1_0_IDENTIFIER)) {
                throw new IllegalArgumentException("Unsupported XPath  version: " + xpathVersion);
            }
            this.xpathVersion = 1;
        } else {
            this.xpathVersion = 0;
        }
        this.proxySetup(attributeFactoryProxy, combiningAlgFactoryProxy, functionFactoryProxy);
    }

    private void proxySetup(AttributeFactoryProxy attributeFactoryProxy, CombiningAlgFactoryProxy combiningAlgFactoryProxy, FunctionFactoryProxy functionFactoryProxy) {
        this.afProxy = attributeFactoryProxy == null ? new AttributeFactoryProxy(){

            public AttributeFactory getFactory() {
                return AttributeFactory.getInstance();
            }
        } : attributeFactoryProxy;
        this.cafProxy = combiningAlgFactoryProxy == null ? new CombiningAlgFactoryProxy(){

            public CombiningAlgFactory getFactory() {
                return CombiningAlgFactory.getInstance();
            }
        } : combiningAlgFactoryProxy;
        this.ffProxy = functionFactoryProxy == null ? FunctionFactory.getInstance() : functionFactoryProxy;
    }

    public int getXACMLVersion() {
        return this.xacmlVersion;
    }

    public String getXACMLIdentifier() {
        return xacmlIdentifiers[this.xacmlVersion];
    }

    public int getXPathVersion() {
        return this.xpathVersion;
    }

    public String getXPathIdentifier() {
        return xpathIdentifiers[this.xpathVersion];
    }

    public AttributeFactory getAttributeFactory() {
        return this.afProxy.getFactory();
    }

    public CombiningAlgFactory getCombiningAlgFactory() {
        return this.cafProxy.getFactory();
    }

    public FunctionFactory getTargetFunctionFactory() {
        return this.ffProxy.getTargetFactory();
    }

    public FunctionFactory getConditionFunctionFactory() {
        return this.ffProxy.getConditionFactory();
    }

    public FunctionFactory getGeneralFunctionFactory() {
        return this.ffProxy.getGeneralFactory();
    }
}

