/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.pip;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.util.AdminServicesUtil;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.identity.entitlement.pip.AbstractPIPAttributeFinder;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.claim.Claim;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class DefaultAttributeFinder
extends AbstractPIPAttributeFinder {
    private Set<String> supportedAttrs = new HashSet<String>();
    private static Log log = LogFactory.getLog(DefaultAttributeFinder.class);
    private UserRealm realm;

    @Override
    public void init(Properties properties) throws Exception {
        this.realm = EntitlementServiceComponent.getRealmservice().getBootstrapRealm();
        ClaimManager claimAdmin = this.realm.getClaimManager();
        Claim[] claims = (Claim[])claimAdmin.getAllClaims("http://wso2.org/claims");
        for (int i = 0; i < claims.length; ++i) {
            this.supportedAttrs.add(claims[i].getClaimUri());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"DefaultAttributeFinder executed successfully");
        }
    }

    @Override
    public Set<String> getAttributeValues(String subjectId, String resourceId, String actionId, String environmentId, String attributeId, String issuer) throws Exception {
        HashSet<String> values = new HashSet<String>();
        subjectId = MultitenantUtils.getTenantAwareUsername((String)subjectId);
        if ("http://wso2.org/claims/role".equals(attributeId)) {
            String[] roles;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Looking for roles via DefaultAttributeFinder");
            }
            if ((roles = AdminServicesUtil.getUserRealm().getUserStoreManager().getRoleListOfUser(subjectId)) != null && roles.length > 0) {
                for (int i = 0; i < roles.length; ++i) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("User %1$s belongs to the Rolw %2$s", subjectId, roles[i]));
                    }
                    values.add(roles[i]);
                }
            }
        } else {
            this.realm = IdentityTenantUtil.getRealm(null, (String)subjectId);
            String claimValue = this.realm.getUserStoreManager().getUserClaimValue(subjectId, attributeId, null);
            if (claimValue == null && log.isDebugEnabled()) {
                log.debug((Object)String.format("Request attribute %1$s not found", attributeId));
            }
            values.add(claimValue);
        }
        return values;
    }

    @Override
    public Set<String> getSupportedAttributes() {
        return this.supportedAttrs;
    }
}

