/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.pip;

import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.jsr107cache.Cache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.wso2.balana.ParsingException;
import org.wso2.balana.attr.AttributeValue;
import org.wso2.balana.attr.BagAttribute;
import org.wso2.balana.cond.EvaluationResult;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.ctx.Status;
import org.wso2.balana.finder.AttributeFinderModule;
import org.wso2.carbon.caching.core.identity.IdentityCacheEntry;
import org.wso2.carbon.caching.core.identity.IdentityCacheKey;
import org.wso2.carbon.identity.entitlement.EntitlementUtil;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.identity.entitlement.pip.PIPAttributeFinder;

public class CarbonAttributeFinder
extends AttributeFinderModule {
    private Map<String, List<PIPAttributeFinder>> attrFinders = new HashMap<String, List<PIPAttributeFinder>>();
    private static Log log = LogFactory.getLog(CarbonAttributeFinder.class);
    private Cache attributeFinderCache = null;
    private boolean isAttributeCachingEnabled = false;
    private int tenantId;

    public CarbonAttributeFinder(int tenantId) {
        this.tenantId = tenantId;
    }

    public void init() {
        Map<PIPAttributeFinder, Properties> designators = EntitlementServiceComponent.getEntitlementConfig().getDesignators();
        Properties properties = EntitlementServiceComponent.getEntitlementConfig().getCachingProperties();
        if ("true".equals(properties.getProperty("AttributeCaching.Enable"))) {
            this.attributeFinderCache = EntitlementUtil.getCommonCache("PIP_ATTRIBUTE_CACHE");
            this.isAttributeCachingEnabled = true;
        }
        if (designators != null && !designators.isEmpty()) {
            Set<PIPAttributeFinder> pipAttributeFinders = designators.keySet();
            for (PIPAttributeFinder pipAttributeFinder : pipAttributeFinders) {
                Set<String> attrs = pipAttributeFinder.getSupportedAttributes();
                if (attrs == null) continue;
                for (String attr : attrs) {
                    List<Object> finders;
                    if (this.attrFinders.containsKey(attr)) {
                        finders = this.attrFinders.get(attr);
                        if (finders.contains(pipAttributeFinder)) continue;
                        finders.add(pipAttributeFinder);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)String.format("PIP attribute handler %1$s registered for the supported attribute %2$s", pipAttributeFinder.getClass(), attr));
                        continue;
                    }
                    finders = new ArrayList<PIPAttributeFinder>();
                    finders.add(pipAttributeFinder);
                    this.attrFinders.put(attr, finders);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)String.format("PIP attribute handler %1$s registered for the supported attribute %2$s", pipAttributeFinder.getClass(), attr));
                }
            }
        }
    }

    public EvaluationResult findAttribute(URI attributeType, URI attributeId, String issuer, URI category, EvaluationCtx context) {
        ArrayList<AttributeValue> attrBag = new ArrayList<AttributeValue>();
        List<PIPAttributeFinder> finders = this.attrFinders.get(attributeId.toString());
        if (finders == null || finders.size() == 0) {
            try {
                this.refreshAttributeFindersForNewAttributeId();
            }
            catch (Exception e) {
                log.warn((Object)"Error while refreshing attribute finders");
            }
            finders = this.attrFinders.get(attributeId.toString());
            if (finders == null || finders.size() == 0) {
                log.info((Object)("No attribute designators defined for the attribute " + attributeId.toString()));
                ArrayList<String> code = new ArrayList<String>();
                code.add("urn:oasis:names:tc:xacml:1.0:status:missing-attribute");
                Status status = new Status(code, "No attribute designators defined for the attribute " + attributeId.toString());
                return new EvaluationResult(status);
            }
        }
        try {
            for (PIPAttributeFinder pipAttributeFinder : finders) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Finding attributes with the PIP attribute handler %1$s", pipAttributeFinder.getClass()));
                }
                Set<String> attrs = null;
                IdentityCacheKey cacheKey = null;
                if (this.isAttributeCachingEnabled && !pipAttributeFinder.overrideDefaultCache()) {
                    IdentityCacheEntry entry;
                    String key = attributeType.toString() + attributeId.toString() + category.toString() + this.domToString(context.getRequestRoot());
                    if (issuer != null) {
                        key = key + issuer;
                    }
                    if (key != null && (entry = (IdentityCacheEntry)this.attributeFinderCache.get((Object)(cacheKey = new IdentityCacheKey(this.tenantId, key)))) != null) {
                        String[] values = entry.getCacheEntryArray();
                        attrs = new HashSet<String>(Arrays.asList(values));
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Carbon Attribute Cache Hit");
                        }
                    }
                }
                if (attrs == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Carbon Attribute Cache Miss");
                    }
                    attrs = pipAttributeFinder.getAttributeValues(attributeType, attributeId, category, issuer, context);
                    if (this.isAttributeCachingEnabled && cacheKey != null && !pipAttributeFinder.overrideDefaultCache()) {
                        IdentityCacheEntry cacheEntry = new IdentityCacheEntry(attrs.toArray(new String[attrs.size()]));
                        this.attributeFinderCache.put((Object)cacheKey, (Object)cacheEntry);
                    }
                }
                if (attrs == null) continue;
                for (String attr : attrs) {
                    AttributeValue attribute = EntitlementUtil.getAttributeValue(attr, attributeType.toString());
                    attrBag.add(attribute);
                }
            }
        }
        catch (ParsingException e) {
            log.error((Object)("Error while parsing attribute values from EvaluationCtx : " + (Object)((Object)e)));
            ArrayList<String> code = new ArrayList<String>();
            code.add("urn:oasis:names:tc:xacml:1.0:status:missing-attribute");
            Status status = new Status(code, "Error while parsing attribute values from EvaluationCtx : " + e.getMessage());
            return new EvaluationResult(status);
        }
        catch (ParseException e) {
            e.printStackTrace();
            log.error((Object)("Error while parsing attribute values from EvaluationCtx : " + e));
            ArrayList<String> code = new ArrayList<String>();
            code.add("urn:oasis:names:tc:xacml:1.0:status:missing-attribute");
            Status status = new Status(code, "Error while parsing attribute values from EvaluationCtx : " + e.getMessage());
            return new EvaluationResult(status);
        }
        catch (URISyntaxException e) {
            log.error((Object)("Error while parsing attribute values from EvaluationCtx : " + e));
            ArrayList<String> code = new ArrayList<String>();
            code.add("urn:oasis:names:tc:xacml:1.0:status:missing-attribute");
            Status status = new Status(code, "Error while parsing attribute values from EvaluationCtx :" + e.getMessage());
            return new EvaluationResult(status);
        }
        catch (Exception e) {
            log.error((Object)("Error while retrieving attribute values from PIP  attribute finder : " + e));
            ArrayList<String> code = new ArrayList<String>();
            code.add("urn:oasis:names:tc:xacml:1.0:status:missing-attribute");
            Status status = new Status(code, "Error while retrieving attribute values from PIP attribute finder : " + e.getMessage());
            return new EvaluationResult(status);
        }
        return new EvaluationResult((AttributeValue)new BagAttribute(attributeType, attrBag));
    }

    public boolean isDesignatorSupported() {
        return true;
    }

    public Set getSupportedDesignatorTypes() {
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(3);
        set.add(0);
        set.add(2);
        set.add(1);
        return set;
    }

    public Set getSupportedIds() {
        return null;
    }

    private void refreshAttributeFindersForNewAttributeId() throws Exception {
        Map<PIPAttributeFinder, Properties> designators = EntitlementServiceComponent.getEntitlementConfig().getDesignators();
        if (designators != null && !designators.isEmpty()) {
            Set<Map.Entry<PIPAttributeFinder, Properties>> attributeFinders = designators.entrySet();
            for (Map.Entry<PIPAttributeFinder, Properties> attributeFinder : attributeFinders) {
                attributeFinder.getKey().init(attributeFinder.getValue());
            }
            this.init();
        }
    }

    public void disableAttributeCache() {
        this.attributeFinderCache = null;
    }

    public void enableAttributeCache() {
        this.attributeFinderCache = EntitlementUtil.getCommonCache("PIP_ATTRIBUTE_CACHE");
    }

    public void clearAttributeCache() {
        if (this.attributeFinderCache != null) {
            this.attributeFinderCache.clear();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Attribute value cache is cleared for tenant " + this.tenantId));
            }
        }
    }

    private String domToString(Node node) throws TransformerException {
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        StringWriter buffer = new StringWriter();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(new DOMSource(node), new StreamResult(buffer));
        return buffer.toString();
    }
}

