/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.xacml3;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.AbstractObligation;
import org.wso2.balana.ObligationResult;
import org.wso2.balana.ParsingException;
import org.wso2.balana.PolicyMetaData;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.xacml3.AttributeAssignment;
import org.wso2.balana.xacml3.AttributeAssignmentExpression;
import org.wso2.balana.xacml3.Obligation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObligationExpression
extends AbstractObligation {
    private List<AttributeAssignmentExpression> expressions;

    public ObligationExpression(int fulfillOn, List<AttributeAssignmentExpression> expressions, URI obligationId) {
        this.fulfillOn = fulfillOn;
        this.expressions = expressions;
        this.obligationId = obligationId;
    }

    public static ObligationExpression getInstance(Node root, PolicyMetaData metaData) throws ParsingException {
        int fulfillOn;
        String effect;
        URI obligationId;
        ArrayList<AttributeAssignmentExpression> expressions = new ArrayList<AttributeAssignmentExpression>();
        if (!root.getNodeName().equals("ObligationExpression")) {
            throw new ParsingException("ObligationExpression object cannot be created with root node of type: " + root.getNodeName());
        }
        NamedNodeMap nodeAttributes = root.getAttributes();
        try {
            obligationId = new URI(nodeAttributes.getNamedItem("ObligationId").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required ObligationId in ObligationExpressionType", e);
        }
        try {
            effect = nodeAttributes.getNamedItem("FulfillOn").getNodeValue();
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required FulfillOn in ObligationExpressionType", e);
        }
        if ("Permit".equals(effect)) {
            fulfillOn = 0;
        } else if ("Deny".equals(effect)) {
            fulfillOn = 1;
        } else {
            throw new ParsingException("Invalid FulfillOn : " + effect);
        }
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!"AttributeAssignmentExpression".equals(child.getNodeName())) continue;
            expressions.add(AttributeAssignmentExpression.getInstance(child, metaData));
        }
        return new ObligationExpression(fulfillOn, expressions, obligationId);
    }

    @Override
    public ObligationResult evaluate(EvaluationCtx ctx) {
        ArrayList<AttributeAssignment> assignments = new ArrayList<AttributeAssignment>();
        for (AttributeAssignmentExpression expression : this.expressions) {
            Set<AttributeAssignment> assignmentSet = expression.evaluate(ctx);
            if (assignmentSet == null || assignmentSet.size() <= 0) continue;
            assignments.addAll(assignmentSet);
        }
        return new Obligation(assignments, this.obligationId);
    }

    public String encode() {
        return null;
    }
}

