/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.xacml3;

import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.Indenter;
import org.wso2.balana.ObligationResult;
import org.wso2.balana.ParsingException;
import org.wso2.balana.xacml3.AttributeAssignment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Obligation
implements ObligationResult {
    private URI obligationId;
    private List<AttributeAssignment> assignments;
    private int fulfillOn = -1;

    public Obligation(List<AttributeAssignment> assignments, URI obligationId) {
        this.assignments = assignments;
        this.obligationId = obligationId;
    }

    public static Obligation getInstance(Node root) throws ParsingException {
        URI obligationId;
        ArrayList<AttributeAssignment> assignments = new ArrayList<AttributeAssignment>();
        if (!root.getNodeName().equals("Obligation")) {
            throw new ParsingException("Obligation object cannot be created with root node of type: " + root.getNodeName());
        }
        NamedNodeMap nodeAttributes = root.getAttributes();
        try {
            obligationId = new URI(nodeAttributes.getNamedItem("ObligationId").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required ObligationId in ObligationType", e);
        }
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!"AttributeAssignment".equals(child.getNodeName())) continue;
            assignments.add(AttributeAssignment.getInstance(child));
        }
        return new Obligation(assignments, obligationId);
    }

    @Override
    public void encode(OutputStream output, Indenter indenter) {
        String indent = indenter.makeString();
        PrintStream out = new PrintStream(output);
        out.println(indent + "<Obligation ObligationId=\"" + this.obligationId + "\">");
        indenter.in();
        if (this.assignments != null && this.assignments.size() > 0) {
            for (AttributeAssignment assignment : this.assignments) {
                assignment.encode(output, indenter);
            }
        }
        indenter.out();
        out.println(indent + "</Obligation>");
    }

    @Override
    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }
}

