/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.finder;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.balana.PolicyMetaData;
import org.wso2.balana.VersionConstraints;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.ctx.Status;
import org.wso2.balana.finder.PolicyFinderModule;
import org.wso2.balana.finder.PolicyFinderResult;

public class PolicyFinder {
    private Set allModules;
    private Set requestModules;
    private Set referenceModules;
    private static Log logger = LogFactory.getLog(PolicyFinder.class);

    public Set getModules() {
        return new HashSet(this.allModules);
    }

    public void setModules(Set modules) {
        Iterator it = modules.iterator();
        this.allModules = new HashSet(modules);
        this.requestModules = new HashSet();
        this.referenceModules = new HashSet();
        while (it.hasNext()) {
            PolicyFinderModule module = (PolicyFinderModule)it.next();
            if (module.isRequestSupported()) {
                this.requestModules.add(module);
            }
            if (!module.isIdReferenceSupported()) continue;
            this.referenceModules.add(module);
        }
    }

    public void init() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Initializing PolicyFinder");
        }
        for (PolicyFinderModule module : this.allModules) {
            module.init(this);
        }
    }

    public PolicyFinderResult findPolicy(EvaluationCtx context) {
        PolicyFinderResult result = null;
        for (PolicyFinderModule module : this.requestModules) {
            PolicyFinderResult newResult = module.findPolicy(context);
            if (newResult.indeterminate()) {
                logger.info((Object)("An error occured while trying to find a single applicable policy for a request: " + newResult.getStatus().getMessage()));
                return newResult;
            }
            if (newResult.notApplicable()) continue;
            if (result != null) {
                logger.info((Object)"More than one top-level applicable policy for the request");
                ArrayList<String> code = new ArrayList<String>();
                code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
                Status status = new Status(code, "too many applicable top-level policies");
                return new PolicyFinderResult(status);
            }
            result = newResult;
        }
        if (result != null) {
            return result;
        }
        logger.info((Object)"No applicable policies were found for the request");
        return new PolicyFinderResult();
    }

    public PolicyFinderResult findPolicy(URI idReference, int type, VersionConstraints constraints, PolicyMetaData parentMetaData) throws IllegalArgumentException {
        PolicyFinderResult result = null;
        Iterator it = this.referenceModules.iterator();
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException("Unknown reference type");
        }
        while (it.hasNext()) {
            PolicyFinderModule module = (PolicyFinderModule)it.next();
            PolicyFinderResult newResult = module.findPolicy(idReference, type, constraints, parentMetaData);
            if (newResult.indeterminate()) {
                logger.info((Object)("An error occured while trying to find the referenced policy " + idReference.toString() + ": " + newResult.getStatus().getMessage()));
                return newResult;
            }
            if (newResult.notApplicable()) continue;
            if (result != null) {
                logger.info((Object)("More than one policy applies for the reference: " + idReference.toString()));
                ArrayList<String> code = new ArrayList<String>();
                code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
                Status status = new Status(code, "too many applicable top-level policies");
                return new PolicyFinderResult(status);
            }
            result = newResult;
        }
        if (result != null) {
            return result;
        }
        logger.info((Object)("No policies were resolved for the reference: " + idReference.toString()));
        return new PolicyFinderResult();
    }
}

