/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.ctx;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.Indenter;
import org.wso2.balana.MatchResult;
import org.wso2.balana.ParsingException;
import org.wso2.balana.ctx.AbstractResult;
import org.wso2.balana.xacml3.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseCtx {
    private Set<AbstractResult> results = null;
    private List<MatchResult> matches = null;

    public List<MatchResult> getMatches() {
        return this.matches;
    }

    public ResponseCtx(AbstractResult result) {
        this.results = new HashSet<AbstractResult>();
        this.results.add(result);
    }

    public ResponseCtx(Set results) {
        this.results = Collections.unmodifiableSet(new HashSet(results));
    }

    public static ResponseCtx getInstance(Node root) throws ParsingException {
        HashSet<AbstractResult> results = new HashSet<AbstractResult>();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!node.getNodeName().equals("Result")) continue;
            results.add(Result.getInstance(node));
        }
        if (results.size() == 0) {
            throw new ParsingException("must have at least one Result");
        }
        return new ResponseCtx(results);
    }

    public Set getResults() {
        return this.results;
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        out.println(indent + "<Response>");
        Iterator<AbstractResult> it = this.results.iterator();
        indenter.in();
        while (it.hasNext()) {
            AbstractResult result = it.next();
            result.encode(out, indenter);
        }
        indenter.out();
        out.println(indent + "</Response>");
    }
}

