/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.cond;

import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Node;
import org.wso2.balana.Indenter;
import org.wso2.balana.ParsingException;
import org.wso2.balana.PolicyMetaData;
import org.wso2.balana.ProcessingException;
import org.wso2.balana.cond.Evaluatable;
import org.wso2.balana.cond.EvaluationResult;
import org.wso2.balana.cond.Expression;
import org.wso2.balana.cond.VariableDefinition;
import org.wso2.balana.cond.VariableManager;
import org.wso2.balana.ctx.EvaluationCtx;

public class VariableReference
implements Expression {
    private String variableId;
    private VariableDefinition definition = null;
    private VariableManager manager = null;

    public VariableReference(String variableId) {
        this.variableId = variableId;
    }

    public VariableReference(VariableDefinition definition) {
        this.variableId = definition.getVariableId();
        this.definition = definition;
    }

    public VariableReference(String variableId, VariableManager manager) {
        this.variableId = variableId;
        this.manager = manager;
    }

    public static VariableReference getInstance(Node root, PolicyMetaData metaData, VariableManager manager) throws ParsingException {
        String variableId = root.getAttributes().getNamedItem("VariableId").getNodeValue();
        return new VariableReference(variableId, manager);
    }

    public String getVariableId() {
        return this.variableId;
    }

    public VariableDefinition getReferencedDefinition() {
        if (this.definition != null) {
            return this.definition;
        }
        if (this.manager != null) {
            return this.manager.getDefinition(this.variableId);
        }
        return null;
    }

    public EvaluationResult evaluate(EvaluationCtx context) {
        Expression xpr = this.getReferencedDefinition().getExpression();
        return ((Evaluatable)xpr).evaluate(context);
    }

    public URI getType() {
        if (this.definition != null) {
            return this.definition.getExpression().getType();
        }
        if (this.manager != null) {
            return this.manager.getVariableType(this.variableId);
        }
        throw new ProcessingException("couldn't resolve the type");
    }

    public boolean returnsBag() {
        if (this.definition != null) {
            return this.getReferencedDefinition().getExpression().returnsBag();
        }
        if (this.manager != null) {
            return this.manager.returnsBag(this.variableId);
        }
        throw new ProcessingException("couldn't resolve the return type");
    }

    public boolean evaluatesToBag() {
        return this.returnsBag();
    }

    public List getChildren() {
        return Collections.EMPTY_LIST;
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        out.println(indent + "<VariableReference VariableId=\"" + this.variableId + "\"/>");
    }
}

