/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.cond;

import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.Indenter;
import org.wso2.balana.ParsingException;
import org.wso2.balana.PolicyMetaData;
import org.wso2.balana.cond.Evaluatable;
import org.wso2.balana.cond.EvaluationResult;
import org.wso2.balana.cond.Expression;
import org.wso2.balana.cond.ExpressionHandler;
import org.wso2.balana.cond.Function;
import org.wso2.balana.cond.FunctionFactory;
import org.wso2.balana.cond.VariableManager;
import org.wso2.balana.ctx.EvaluationCtx;

public class Apply
implements Evaluatable {
    private Function function;
    private List xprs;

    public Apply(Function function, List xprs) throws IllegalArgumentException {
        function.checkInputs(xprs);
        this.function = function;
        this.xprs = Collections.unmodifiableList(new ArrayList(xprs));
    }

    public Apply(Function function, List xprs, boolean isCondition) throws IllegalArgumentException {
        if (isCondition) {
            throw new IllegalArgumentException("As of version 2.0 an Apply may not represent a Condition");
        }
        function.checkInputs(xprs);
        this.function = function;
        this.xprs = Collections.unmodifiableList(new ArrayList(xprs));
    }

    public static Apply getConditionInstance(Node root, String xpathVersion, VariableManager manager) throws ParsingException {
        return Apply.getInstance(root, FunctionFactory.getConditionInstance(), new PolicyMetaData("urn:oasis:names:tc:xacml:1.0:policy", xpathVersion), manager);
    }

    public static Apply getConditionInstance(Node root, String xpathVersion) throws ParsingException {
        return Apply.getInstance(root, FunctionFactory.getConditionInstance(), new PolicyMetaData("urn:oasis:names:tc:xacml:1.0:policy", xpathVersion), null);
    }

    public static Apply getInstance(Node root, PolicyMetaData metaData, VariableManager manager) throws ParsingException {
        return Apply.getInstance(root, FunctionFactory.getGeneralInstance(), metaData, manager);
    }

    public static Apply getInstance(Node root, String xpathVersion) throws ParsingException {
        return Apply.getInstance(root, FunctionFactory.getGeneralInstance(), new PolicyMetaData("urn:oasis:names:tc:xacml:1.0:policy", xpathVersion), null);
    }

    private static Apply getInstance(Node root, FunctionFactory factory, PolicyMetaData metaData, VariableManager manager) throws ParsingException {
        Function function = ExpressionHandler.getFunction(root, metaData, factory);
        ArrayList<Expression> xprs = new ArrayList<Expression>();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Expression xpr = ExpressionHandler.parseExpression(nodes.item(i), metaData, manager);
            if (xpr == null) continue;
            xprs.add(xpr);
        }
        return new Apply(function, xprs);
    }

    public Function getFunction() {
        return this.function;
    }

    public List getChildren() {
        return this.xprs;
    }

    public boolean isCondition() {
        return false;
    }

    public EvaluationResult evaluate(EvaluationCtx context) {
        return this.function.evaluate(this.xprs, context);
    }

    public URI getType() {
        return this.function.getReturnType();
    }

    public boolean returnsBag() {
        return this.function.returnsBag();
    }

    public boolean evaluatesToBag() {
        return this.function.returnsBag();
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        out.println(indent + "<Apply FunctionId=\"" + this.function.getIdentifier() + "\">");
        indenter.in();
        for (Expression xpr : this.xprs) {
            xpr.encode(output, indenter);
        }
        indenter.out();
        out.println(indent + "</Apply>");
    }
}

