/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.combine;

import java.io.OutputStream;
import java.io.PrintStream;
import org.w3c.dom.Node;
import org.wso2.balana.Indenter;
import org.wso2.balana.ParsingException;
import org.wso2.balana.UnknownIdentifierException;
import org.wso2.balana.attr.AttributeFactory;
import org.wso2.balana.attr.AttributeValue;

public class CombinerParameter {
    private String name;
    private AttributeValue value;

    public CombinerParameter(String name, AttributeValue value) {
        this.name = name;
        this.value = value;
    }

    public static CombinerParameter getInstance(Node root) throws ParsingException {
        String name = root.getAttributes().getNamedItem("ParameterName").getNodeValue();
        AttributeFactory attrFactory = AttributeFactory.getInstance();
        AttributeValue value = null;
        try {
            value = attrFactory.createValue(root.getFirstChild());
        }
        catch (UnknownIdentifierException uie) {
            throw new ParsingException("Unknown AttributeId", uie);
        }
        return new CombinerParameter(name, value);
    }

    public String getName() {
        return this.name;
    }

    public AttributeValue getValue() {
        return this.value;
    }

    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        out.println(indent + "<CombinerParameter ParameterName=\"" + this.getName() + "\">");
        indenter.in();
        this.getValue().encode(output, indenter);
        out.println(indent + "</CombinerParameter>");
        indenter.out();
    }
}

