/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.balana.AbstractPolicy;
import org.wso2.balana.Indenter;
import org.wso2.balana.MultipleCtxResult;
import org.wso2.balana.PDPConfig;
import org.wso2.balana.ParsingException;
import org.wso2.balana.Policy;
import org.wso2.balana.PolicySet;
import org.wso2.balana.ResultFactory;
import org.wso2.balana.ctx.AbstractRequestCtx;
import org.wso2.balana.ctx.AbstractResult;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.ctx.EvaluationCtxFactory;
import org.wso2.balana.ctx.RequestCtxFactory;
import org.wso2.balana.ctx.ResponseCtx;
import org.wso2.balana.ctx.Status;
import org.wso2.balana.finder.PolicyFinder;
import org.wso2.balana.finder.PolicyFinderResult;
import org.wso2.balana.xacml3.ctx.RequestCtx;
import org.wso2.balana.xacml3.ctx.XACML3EvaluationCtx;

public class PDP {
    private PDPConfig pdpConfig;
    private PolicyFinder policyFinder;
    private static Log logger = LogFactory.getLog(PDP.class);

    public PDP(PDPConfig pdpConfig) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"creating a PDP");
        }
        this.pdpConfig = pdpConfig;
        this.policyFinder = pdpConfig.getPolicyFinder();
        this.policyFinder.init();
    }

    public ResponseCtx evaluate(AbstractRequestCtx request) {
        EvaluationCtx evalContext = null;
        try {
            evalContext = EvaluationCtxFactory.getFactory().getEvaluationCtx(request, this.pdpConfig);
            return this.evaluate(evalContext);
        }
        catch (ParsingException pe) {
            logger.error((Object)"the PDP received an invalid request", (Throwable)pe);
            ArrayList<String> code = new ArrayList<String>();
            code.add("urn:oasis:names:tc:xacml:1.0:status:syntax-error");
            Status status = new Status(code, pe.getMessage());
            return new ResponseCtx(ResultFactory.getFactory().getResult(2, status, evalContext));
        }
    }

    public ResponseCtx evaluate(EvaluationCtx context) {
        if (this.pdpConfig.isMultipleRequestHandle()) {
            MultipleCtxResult multipleCtxResult = context.getMultipleEvaluationCtx();
            if (multipleCtxResult.isIndeterminate()) {
                return new ResponseCtx(ResultFactory.getFactory().getResult(2, multipleCtxResult.getStatus(), context));
            }
            Set<EvaluationCtx> evaluationCtxSet = multipleCtxResult.getEvaluationCtxSet();
            HashSet<AbstractResult> results = new HashSet<AbstractResult>();
            for (EvaluationCtx ctx : evaluationCtxSet) {
                AbstractResult result = this.evaluateContext(ctx);
                results.add(result);
            }
            return new ResponseCtx(results);
        }
        if (context instanceof XACML3EvaluationCtx && ((XACML3EvaluationCtx)context).isMultipleAttributes()) {
            ArrayList<String> code = new ArrayList<String>();
            code.add("urn:oasis:names:tc:xacml:1.0:status:syntax-error");
            Status status = new Status(code, "PDP does not supports multiple decision profile. Multiple <Attributes> elements with the same Category can be existed");
            return new ResponseCtx(ResultFactory.getFactory().getResult(2, status, context));
        }
        if (context instanceof XACML3EvaluationCtx && ((RequestCtx)context.getRequestCtx()).isCombinedDecision()) {
            ArrayList<String> code = new ArrayList<String>();
            code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
            Status status = new Status(code, "PDP does not supports multiple decision profile. Multiple decision is not existed to combine them");
            return new ResponseCtx(ResultFactory.getFactory().getResult(2, status, context));
        }
        return new ResponseCtx(this.evaluateContext(context));
    }

    private AbstractResult evaluateContext(EvaluationCtx context) {
        PolicyFinderResult finderResult = this.policyFinder.findPolicy(context);
        if (finderResult.notApplicable()) {
            return ResultFactory.getFactory().getResult(3, context);
        }
        if (finderResult.indeterminate()) {
            return ResultFactory.getFactory().getResult(2, finderResult.getStatus(), context);
        }
        HashSet<String> policyIds = new HashSet<String>();
        AbstractPolicy policy = finderResult.getPolicy();
        if (policy instanceof Policy) {
            policyIds.add(policy.getId().toString());
        } else if (policy instanceof PolicySet) {
            for (AbstractPolicy child : policy.getChildElements()) {
                policyIds.add(child.getId().toString());
            }
        }
        return finderResult.getPolicy().evaluate(context);
    }

    public OutputStream evaluate(InputStream input) {
        AbstractRequestCtx request = null;
        ResponseCtx response = null;
        try {
            request = RequestCtxFactory.getFactory().getRequestCtx(input);
        }
        catch (Exception pe) {
            ArrayList<String> code = new ArrayList<String>();
            code.add("urn:oasis:names:tc:xacml:1.0:status:syntax-error");
            Status status = new Status(code, "invalid request: " + pe.getMessage());
            response = new ResponseCtx(ResultFactory.getFactory().getResult(2, status, 3));
        }
        if (response == null) {
            response = this.evaluate(request);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        response.encode(out, new Indenter());
        return out;
    }
}

