/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.registration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.wso2.carbon.identity.base.IdentityConstants;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.IdentityClaimManager;
import org.wso2.carbon.identity.core.persistence.IdentityPersistenceManager;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.user.registration.dto.UserDTO;
import org.wso2.carbon.identity.user.registration.dto.UserFieldDTO;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.user.core.Permission;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.claim.Claim;

public class UserRegistrationService {
    public UserFieldDTO[] readUserFieldsForUserRegistration(String dialect) throws IdentityException {
        IdentityClaimManager claimManager = null;
        Claim[] claims = null;
        ArrayList<UserFieldDTO> claimList = null;
        UserRealm realm = null;
        claimManager = IdentityClaimManager.getInstance();
        claims = claimManager.getAllSupportedClaims(dialect, realm = IdentityTenantUtil.getRealm(null, null));
        if (claims == null || claims.length == 0) {
            return new UserFieldDTO[0];
        }
        claimList = new ArrayList<UserFieldDTO>();
        for (Claim claim : claims) {
            if (claim.getDisplayTag() == null || IdentityConstants.PPID_DISPLAY_VALUE.equals(claim.getDisplayTag()) || "http://wso2.org/claims/accountStatus".equals(claim.getClaimUri())) continue;
            claimList.add(this.getUserFieldDTO(claim.getClaimUri(), claim.getDisplayTag(), claim.isRequired(), claim.getDisplayOrder(), claim.getRegEx()));
        }
        return claimList.toArray(new UserFieldDTO[claimList.size()]);
    }

    public void addUser(UserDTO user) throws Exception {
        UserFieldDTO[] userFieldDTOs = null;
        HashMap<String, String> userClaims = null;
        userFieldDTOs = user.getUserFields();
        userClaims = new HashMap<String, String>();
        if (userFieldDTOs != null) {
            for (UserFieldDTO userFieldDTO : userFieldDTOs) {
                userClaims.put(userFieldDTO.getClaimUri(), userFieldDTO.getFieldValue());
            }
        }
        UserRealm realm = null;
        realm = IdentityTenantUtil.getRealm(null, null);
        Registry registry = IdentityTenantUtil.getRegistry(null, null);
        this.addUser(user.getUserName(), user.getPassword(), userClaims, null, realm);
        if (user.getOpenID() != null) {
            IdentityPersistenceManager persistentManager = IdentityPersistenceManager.getPersistanceManager();
            persistentManager.doOpenIdSignUp(registry, realm, user.getOpenID(), user.getUserName());
        }
    }

    public boolean isAddUserEnabled() throws Exception {
        UserStoreManager userStoreManager;
        UserRealm userRealm = IdentityTenantUtil.getRealm(null, null);
        if (userRealm != null && (userStoreManager = userRealm.getUserStoreManager()) != null) {
            return !userStoreManager.isReadOnly();
        }
        return false;
    }

    public boolean isAddUserWithOpenIDEnabled() throws Exception {
        return false;
    }

    public boolean isAddUserWithInfoCardEnabled() throws Exception {
        return false;
    }

    private UserFieldDTO getUserFieldDTO(String claimUri, String displayName, boolean isRequired, int displayOrder, String regex) {
        UserFieldDTO fieldDTO = null;
        fieldDTO = new UserFieldDTO();
        fieldDTO.setClaimUri(claimUri);
        fieldDTO.setFieldName(displayName);
        fieldDTO.setRequired(isRequired);
        fieldDTO.setDisplayOrder(displayOrder);
        fieldDTO.setRegEx(regex);
        return fieldDTO;
    }

    private void addUser(String userName, String password, Map<String, String> claimList, String profileName, UserRealm realm) throws IdentityException {
        UserStoreManager admin = null;
        Permission permission = null;
        try {
            admin = realm.getUserStoreManager();
            admin.addUser(userName, (Object)password, null, claimList, profileName);
            if (!admin.isExistingRole("identity")) {
                permission = new Permission("/permission/admin/login", "ui.execute");
                admin.addRole("identity", new String[]{userName}, new Permission[]{permission});
            } else {
                admin.updateUserListOfRole("identity", new String[0], new String[]{userName});
            }
        }
        catch (UserStoreException e) {
            throw new IdentityException("Error occurred while adding user : " + userName, (Throwable)e);
        }
    }
}

