/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.profile.mgt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.identity.user.profile.mgt.UserFieldDTO;
import org.wso2.carbon.identity.user.profile.mgt.UserProfileDTO;
import org.wso2.carbon.identity.user.profile.mgt.UserProfileException;
import org.wso2.carbon.identity.user.profile.mgt.UserProfileUtil;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.claim.Claim;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.profile.ProfileConfiguration;
import org.wso2.carbon.user.core.profile.ProfileConfigurationManager;

public class UserProfileAdmin
extends AbstractAdmin {
    private static Log log = LogFactory.getLog(UserProfileAdmin.class);

    public boolean isReadOnlyUserStore() throws UserProfileException {
        try {
            UserRealm realm = this.getUserRealm();
            return "true".equals(realm.getRealmConfiguration().getUserStoreProperty("ReadOnly"));
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserProfileException(e.getMessage(), e);
        }
    }

    public void setUserProfile(String username, UserProfileDTO profile) throws UserProfileException {
        UserRealm realm = null;
        try {
            if (!this.isAuthorized(username)) {
                throw new UserProfileException("You are not authorized to perform this action.");
            }
            realm = this.getUserRealm();
            UserFieldDTO[] udatas = profile.getFieldValues();
            HashMap<String, String> map = new HashMap<String, String>();
            for (UserFieldDTO data : udatas) {
                String claimURI = data.getClaimUri();
                String value = data.getFieldValue();
                map.put(claimURI, value);
            }
            if (profile.getProfileConifuration() != null) {
                map.put("profileConfiguration", profile.getProfileConifuration());
            } else {
                map.put("profileConfiguration", "default");
            }
            UserStoreManager admin = realm.getUserStoreManager();
            admin.setUserClaimValues(username, map, profile.getProfileName());
        }
        catch (UserStoreException e) {
            throw new UserProfileException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserProfileException(e.getMessage(), e);
        }
    }

    public void deleteUserProfile(String username, String profileName) throws UserProfileException {
        UserRealm realm = null;
        try {
            if (!this.isAuthorized(username)) {
                throw new UserProfileException("You are not authorized to perform this action.");
            }
            if ("default".equals(profileName)) {
                throw new UserProfileException("Cannot delete default profile");
            }
            realm = this.getUserRealm();
            ClaimManager cman = realm.getClaimManager();
            String[] claims = cman.getAllClaimUris();
            UserStoreManager admin = realm.getUserStoreManager();
            admin.deleteUserClaimValues(username, claims, profileName);
            admin.deleteUserClaimValue(username, "profileConfiguration", profileName);
        }
        catch (UserStoreException e) {
            throw new UserProfileException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserProfileException(e.getMessage(), e);
        }
    }

    public UserProfileDTO[] getUserProfiles(String username) throws UserProfileException {
        UserProfileDTO[] profiles;
        String[] availableProfileConfigurations = new String[]{};
        String profileConfig = null;
        try {
            int i;
            if (!this.isAuthorized(username)) {
                throw new UserProfileException("You are not authorized to perform this action.");
            }
            UserRealm realm = this.getUserRealm();
            UserStoreManager ur = realm.getUserStoreManager();
            ProfileConfigurationManager profileAdmin = realm.getProfileConfigurationManager();
            if (profileAdmin != null) {
                availableProfileConfigurations = this.getAvailableProfileConfiguration(profileAdmin);
            }
            String[] profileNames = ur.getProfileNames(username);
            profiles = new UserProfileDTO[profileNames.length];
            Claim[] claims = this.getAllSupportedClaims(realm, "http://wso2.org/claims");
            String[] claimUris = new String[claims.length + 1];
            for (i = 0; i < claims.length; ++i) {
                claimUris[i] = claims[i].getClaimUri();
            }
            claimUris[claims.length] = "profileConfiguration";
            for (i = 0; i < profileNames.length; ++i) {
                String profile = profileNames[i];
                Map valueMap = ur.getUserClaimValues(username, claimUris, profile);
                ArrayList<UserFieldDTO> userFields = new ArrayList<UserFieldDTO>();
                for (int j = 0; j < claims.length; ++j) {
                    UserFieldDTO data = new UserFieldDTO();
                    Claim claim = claims[j];
                    String claimUri = claim.getClaimUri();
                    if ("profileConfiguration".equals(claimUri)) continue;
                    data.setClaimUri(claimUri);
                    data.setFieldValue((String)valueMap.get(claimUri));
                    data.setDisplayName(claim.getDisplayTag());
                    data.setRegEx(claim.getRegEx());
                    data.setRequired(claim.isRequired());
                    data.setDisplayOrder(claim.getDisplayOrder());
                    userFields.add(data);
                }
                UserProfileDTO temp = new UserProfileDTO();
                temp.setProfileName(profile);
                temp.setFieldValues(userFields.toArray(new UserFieldDTO[userFields.size()]));
                temp.setProfileConfigurations(availableProfileConfigurations);
                profileConfig = (String)valueMap.get("profileConfiguration");
                if (profileConfig == null) {
                    profileConfig = "default";
                }
                temp.setProfileConifuration(profileConfig);
                profiles[i] = temp;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UserProfileException(e.getMessage(), e);
        }
        return profiles;
    }

    public UserProfileDTO getProfileFieldsForInternalStore() throws UserProfileException {
        UserFieldDTO[] datas;
        UserProfileDTO profile = new UserProfileDTO();
        String[] availableProfileConfigurations = new String[]{};
        try {
            UserRealm realm = this.getUserRealm();
            Claim[] claims = this.getClaimsToEnterData(realm);
            ProfileConfigurationManager profileAdmin = realm.getProfileConfigurationManager();
            if (profileAdmin != null) {
                availableProfileConfigurations = this.getAvailableProfileConfiguration(profileAdmin);
            }
            String[] claimUris = new String[claims.length];
            for (int i = 0; i < claims.length; ++i) {
                claimUris[i] = claims[i].getClaimUri();
            }
            datas = new UserFieldDTO[claims.length];
            for (int j = 0; j < claims.length; ++j) {
                UserFieldDTO data = new UserFieldDTO();
                Claim claim = claims[j];
                String claimUri = claim.getClaimUri();
                data.setClaimUri(claimUri);
                data.setDisplayName(claim.getDisplayTag());
                data.setRegEx(claim.getRegEx());
                data.setRequired(claim.isRequired());
                data.setDisplayOrder(claim.getDisplayOrder());
                data.setRegEx(claim.getRegEx());
                datas[j] = data;
            }
        }
        catch (Exception e) {
            throw new UserProfileException(e.getMessage(), e);
        }
        profile.setFieldValues(datas);
        profile.setProfileConfigurations(availableProfileConfigurations);
        return profile;
    }

    public UserProfileDTO getUserProfile(String username, String profileName) throws UserProfileException {
        UserProfileDTO profile = new UserProfileDTO();
        String[] availableProfileConfigurations = new String[]{};
        String profileConfig = null;
        try {
            if (username == null || profileName == null) {
                throw new Exception("Invalid input parameters");
            }
            if (!this.isAuthorized(username)) {
                throw new UserProfileException("You are not authorized to perform this action.");
            }
            UserRealm realm = this.getUserRealm();
            UserStoreManager ur = realm.getUserStoreManager();
            ProfileConfigurationManager profileAdmin = realm.getProfileConfigurationManager();
            String[] profileNames = ur.getProfileNames(username);
            boolean found = false;
            if (profileNames != null && profileNames.length > 0) {
                for (int i = 0; i < profileNames.length; ++i) {
                    if (!profileName.equals(profileNames[i])) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                return null;
            }
            if (profileAdmin != null) {
                availableProfileConfigurations = this.getAvailableProfileConfiguration(profileAdmin);
            }
            Claim[] claims = this.getClaimsToEnterData(realm);
            String[] claimUris = new String[claims.length + 1];
            for (int i = 0; i < claims.length; ++i) {
                claimUris[i] = claims[i].getClaimUri();
            }
            claimUris[claims.length] = "profileConfiguration";
            Map valueMap = ur.getUserClaimValues(username, claimUris, profileName);
            ArrayList<UserFieldDTO> userFields = new ArrayList<UserFieldDTO>();
            for (int j = 0; j < claims.length; ++j) {
                UserFieldDTO data = new UserFieldDTO();
                Claim claim = claims[j];
                String claimUri = claim.getClaimUri();
                if ("profileConfiguration".equals(claimUri)) continue;
                data.setClaimUri(claimUri);
                data.setFieldValue((String)valueMap.get(claimUri));
                data.setDisplayName(claim.getDisplayTag());
                data.setRegEx(claim.getRegEx());
                data.setRequired(claim.isRequired());
                data.setDisplayOrder(claim.getDisplayOrder());
                userFields.add(data);
            }
            profile.setProfileName(profileName);
            profile.setProfileConfigurations(availableProfileConfigurations);
            profileConfig = (String)valueMap.get("profileConfiguration");
            if (profileConfig == null) {
                profileConfig = "default";
            }
            profile.setProfileConifuration(profileConfig);
            profile.setFieldValues(userFields.toArray(new UserFieldDTO[userFields.size()]));
        }
        catch (Exception e) {
            throw new UserProfileException(e.getMessage(), e);
        }
        return profile;
    }

    public boolean isAddProfileEnabled() throws UserProfileException {
        UserRealm realm = this.getUserRealm();
        UserStoreManager userStoreManager = null;
        try {
            userStoreManager = realm.getUserStoreManager();
        }
        catch (UserStoreException e) {
            String errorMessage = "Error in obtaining UserStoreManager.";
            log.error((Object)errorMessage, (Throwable)e);
            throw new UserProfileException(errorMessage, e);
        }
        return userStoreManager.isMultipleProfilesAllowed();
    }

    private Claim[] getClaimsToEnterData(UserRealm realm) throws UserStoreException {
        try {
            return this.getAllSupportedClaims(realm, "http://wso2.org/claims");
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserStoreException((Throwable)e);
        }
    }

    private boolean isAuthorized(String targetUser) throws UserStoreException, CarbonException {
        boolean isAuthrized = false;
        MessageContext msgContext = MessageContext.getCurrentMessageContext();
        HttpServletRequest request = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = request.getSession(false);
        if (httpSession != null) {
            String userName = (String)httpSession.getAttribute("wso2carbon.admin.logged.in");
            isAuthrized = UserProfileUtil.isUserAuthorizedToConfigureProfile(this.getUserRealm(), userName, targetUser);
        }
        return isAuthrized;
    }

    private Claim[] getAllSupportedClaims(UserRealm realm, String dialectUri) throws org.wso2.carbon.user.api.UserStoreException {
        Claim[] claims = null;
        ArrayList<Claim> reqClaims = null;
        claims = (Claim[])realm.getClaimManager().getAllSupportClaimsByDefault();
        reqClaims = new ArrayList<Claim>();
        for (int i = 0; i < claims.length; ++i) {
            if (!dialectUri.equals(claims[i].getDialectURI()) || claims[i] == null || claims[i].getDisplayTag() == null || claims[i].getClaimUri().equals("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier")) continue;
            reqClaims.add(claims[i]);
        }
        return reqClaims.toArray(new Claim[reqClaims.size()]);
    }

    private String[] getAvailableProfileConfiguration(ProfileConfigurationManager profileAdmin) throws UserStoreException {
        ProfileConfiguration[] configurations;
        String[] profileNames = new String[]{};
        try {
            configurations = (ProfileConfiguration[])profileAdmin.getAllProfiles();
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserStoreException((Throwable)e);
        }
        if (configurations != null) {
            profileNames = new String[configurations.length];
            for (int i = 0; i < configurations.length; ++i) {
                profileNames[i] = configurations[i].getProfileName();
            }
        }
        return profileNames;
    }
}

