/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.thrift.authentication.internal;

import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.wso2.carbon.identity.authentication.AuthenticationService;
import org.wso2.carbon.identity.thrift.authentication.AuthenticatorService;
import org.wso2.carbon.identity.thrift.authentication.AuthenticatorServiceImpl;
import org.wso2.carbon.identity.thrift.authentication.AuthenticatorServlet;
import org.wso2.carbon.identity.thrift.authentication.ThriftAuthenticatorService;
import org.wso2.carbon.identity.thrift.authentication.ThriftAuthenticatorServiceImpl;
import org.wso2.carbon.user.core.service.RealmService;

public class ThriftAuthenticationServiceComponent {
    private static Log log = LogFactory.getLog(ThriftAuthenticationServiceComponent.class);
    private static HttpService httpServiceInstance;
    private AuthenticationService authenticationService;
    private static RealmService realmServiceInstance;
    private ServiceRegistration thriftAuthenticationservice;

    protected void activate(ComponentContext compCtx) {
        ThriftAuthenticatorServiceImpl thriftAuthenticatorServiceImpl = ThriftAuthenticatorServiceImpl.getInstance();
        thriftAuthenticatorServiceImpl.init(this.authenticationService, realmServiceInstance);
        this.thriftAuthenticationservice = compCtx.getBundleContext().registerService(ThriftAuthenticatorService.class.getName(), (Object)thriftAuthenticatorServiceImpl, null);
        this.startThriftServices();
    }

    protected void deactivate(ComponentContext compCtx) {
        compCtx.getBundleContext().ungetService(this.thriftAuthenticationservice.getReference());
    }

    protected void setHttpService(HttpService httpService) {
        httpServiceInstance = httpService;
    }

    protected void unsetHttpService(HttpService httpService) {
        httpServiceInstance = null;
    }

    protected void setAuthenticationService(AuthenticationService authService) {
        this.authenticationService = authService;
    }

    protected void unsetAuthenticationService(AuthenticationService authService) {
        this.authenticationService = null;
    }

    protected void setRealmService(RealmService realmService) {
        realmServiceInstance = realmService;
    }

    protected void unsetRealmService(RealmService realmService) {
        realmServiceInstance = null;
    }

    private void startThriftServices() {
        this.startThriftAuthenticatorService();
    }

    private void startThriftAuthenticatorService() {
        try {
            AuthenticatorService.Processor<AuthenticatorServiceImpl> authServiceProcessor = new AuthenticatorService.Processor<AuthenticatorServiceImpl>(new AuthenticatorServiceImpl());
            TCompactProtocol.Factory inProtFactory = new TCompactProtocol.Factory();
            TCompactProtocol.Factory outProtFactory = new TCompactProtocol.Factory();
            httpServiceInstance.registerServlet("/thriftAuthenticator", (Servlet)new AuthenticatorServlet(authServiceProcessor, (TProtocolFactory)inProtFactory, (TProtocolFactory)outProtFactory), new Hashtable(), httpServiceInstance.createDefaultHttpContext());
        }
        catch (ServletException e) {
            log.error((Object)"Unable to start thrift Authenticator Service.");
        }
        catch (NamespaceException e) {
            log.error((Object)"Unable to start thrift Authenticator Service");
        }
    }
}

