/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sts.passive.processors;

import java.security.Principal;
import java.util.Vector;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.util.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.RahasData;
import org.apache.rahas.TrustException;
import org.apache.rahas.impl.SAMLPassiveTokenIssuer;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.handler.WSHandlerResult;
import org.wso2.carbon.identity.sts.passive.ClaimDTO;
import org.wso2.carbon.identity.sts.passive.PassiveSTSService;
import org.wso2.carbon.identity.sts.passive.RequestToken;
import org.wso2.carbon.identity.sts.passive.ResponseToken;
import org.wso2.carbon.identity.sts.passive.processors.RequestProcessor;

public class SigningRequestProcessor
extends RequestProcessor {
    private static final Log log = LogFactory.getLog(SigningRequestProcessor.class);

    @Override
    public ResponseToken process(RequestToken request) throws TrustException {
        MessageContext context = MessageContext.getCurrentMessageContext();
        SAMLPassiveTokenIssuer issuer = null;
        WSHandlerResult handlerResults = null;
        WSSecurityEngineResult engineResult = null;
        WSUsernameTokenPrincipal principal = null;
        Vector<WSSecurityEngineResult> wsResults = null;
        ResponseToken reponseToken = null;
        Vector<WSHandlerResult> handlerResultsVector = null;
        OMElement rstr = null;
        try {
            principal = new WSUsernameTokenPrincipal(request.getUserName(), false);
            engineResult = new WSSecurityEngineResult(1, (Principal)principal, null, null, null);
            wsResults = new Vector<WSSecurityEngineResult>();
            wsResults.add(engineResult);
            handlerResults = new WSHandlerResult("", wsResults);
            handlerResultsVector = new Vector<WSHandlerResult>();
            handlerResultsVector.add(handlerResults);
            MessageContext.getCurrentMessageContext().setProperty("RECV_RESULTS", handlerResultsVector);
            if (request.getAttributes() == null || request.getAttributes().length() == 0) {
                String realm = request.getRealm();
                if (realm == null) {
                    log.warn((Object)"Realm is not set in request token.");
                    String replyTo = request.getReplyTo();
                    URL url = new URL(replyTo);
                    if (url != null) {
                        realm = url.getHost();
                    } else {
                        log.warn((Object)"Failed to get realm from replyTo address.");
                    }
                }
                if (realm != null) {
                    ClaimDTO claimDTO = new PassiveSTSService().getTrustedServiceClaims(realm);
                    StringBuffer claims = new StringBuffer();
                    for (String claim : claimDTO.getDefaultClaims()) {
                        claims.append(claim).append(",");
                    }
                    request.setAttributes(claims.toString());
                    log.debug((Object)"Default claims were added to request.");
                }
            }
            MessageContext.getCurrentMessageContext().setProperty("passiveSTSRST", (Object)this.getRST(request.getRealm(), request.getAttributes()));
            this.rahasData = new RahasData(context);
            issuer = new SAMLPassiveTokenIssuer();
            issuer.setAudienceRestrictionCondition(request.getRealm());
            issuer.setConfig(this.getSAMLTokenIssuerConfig(MessageContext.getCurrentMessageContext().getAxisService(), true));
            rstr = issuer.issuePassiveRSTR(this.rahasData);
            reponseToken = new ResponseToken();
            reponseToken.setResults(rstr.toStringWithConsume());
        }
        catch (Exception e) {
            throw new TrustException("errorWhileProcessingSigninRequest", (Throwable)e);
        }
        return reponseToken;
    }
}

