/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sts.passive.processors;

import java.security.KeyStore;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.RahasData;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.rahas.client.STSClient;
import org.apache.rahas.impl.SAMLTokenIssuerConfig;
import org.apache.ws.secpolicy.Constants;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.core.util.KeyStoreUtil;
import org.wso2.carbon.identity.provider.AttributeCallbackHandler;
import org.wso2.carbon.identity.sts.passive.RequestToken;
import org.wso2.carbon.identity.sts.passive.ResponseToken;
import org.wso2.carbon.identity.sts.passive.internal.IdentityPassiveSTSServiceComponent;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.security.keystore.KeyStoreAdmin;
import org.wso2.carbon.security.keystore.service.KeyStoreData;
import org.wso2.carbon.security.util.RampartConfigUtil;
import org.wso2.carbon.security.util.ServerCrypto;

public abstract class RequestProcessor {
    protected RahasData rahasData = null;
    private static final Log log = LogFactory.getLog(RequestProcessor.class);

    protected OMElement getRST(String appliesTo, String attrs) throws Exception {
        OMFactory factory = null;
        OMElement element = null;
        OMElement claims = null;
        STSClient client = null;
        String[] attributes = null;
        if (attrs != null) {
            attributes = attrs.split(",");
        }
        String requestType = TrustUtil.getWSTNamespaceForRSTRequestTye((int)2) + "/Issue";
        factory = OMAbstractFactory.getOMFactory();
        element = factory.createOMElement(Constants.RST_TEMPLATE);
        TrustUtil.createTokenTypeElement((int)2, (OMElement)element).setText("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
        TrustUtil.createKeyTypeElement((int)2, (OMElement)element, (String)"/SymmetricKey");
        TrustUtil.createKeySizeElement((int)2, (OMElement)element, (int)256);
        if (attributes != null && attributes.length > 0) {
            claims = TrustUtil.createClaims((int)2, (OMElement)element, (String)"http://wso2.org");
            for (int i = 0; i < attributes.length; ++i) {
                this.addClaimType(claims, attributes[i]);
            }
        }
        client = new STSClient(MessageContext.getCurrentMessageContext().getConfigurationContext());
        client.setVersion(2);
        client.setRstTemplate(element);
        return client.createIssueRequest(requestType, appliesTo);
    }

    public abstract ResponseToken process(RequestToken var1) throws TrustException;

    private void addClaimType(OMElement parent, String uri) {
        OMElement element = null;
        element = parent.getOMFactory().createOMElement(new QName("http://schemas.xmlsoap.org/ws/2005/05/identity", "ClaimType", "wsid"), (OMContainer)parent);
        element.addAttribute(parent.getOMFactory().createOMAttribute("Uri", null, uri));
    }

    protected SAMLTokenIssuerConfig getSAMLTokenIssuerConfig(AxisService service, boolean isSuperTenant) throws Exception {
        UserRegistry systemRegistry = null;
        String keyAlias = null;
        String keyPassword = null;
        KeyStoreAdmin admin = null;
        KeyStoreData[] keystores = null;
        String privateKeyAlias = null;
        String keyStoreName = null;
        String issuerName = null;
        ServerConfiguration serverConfig = null;
        systemRegistry = (UserRegistry)IdentityPassiveSTSServiceComponent.getGovernanceSystemRegistry();
        if (systemRegistry == null || service == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"systemRegistry not set or STS service is unavialable");
            }
            return null;
        }
        serverConfig = ServerConfiguration.getInstance();
        keyAlias = serverConfig.getFirstProperty("Security.KeyStore.KeyAlias");
        keyPassword = serverConfig.getFirstProperty("Security.KeyStore.KeyPassword");
        issuerName = serverConfig.getFirstProperty("HostName");
        if (issuerName == null) {
            issuerName = "Identity-passive-sts";
        }
        admin = new KeyStoreAdmin(-1234, (Registry)systemRegistry);
        keystores = admin.getKeyStores(isSuperTenant);
        for (int i = 0; i < keystores.length; ++i) {
            if (!KeyStoreUtil.isPrimaryStore((String)keystores[i].getKeyStoreName())) continue;
            keyStoreName = keystores[i].getKeyStoreName();
            privateKeyAlias = KeyStoreUtil.getPrivateKeyAlias((KeyStore)KeyStoreManager.getInstance((int)-1234).getKeyStore(keyStoreName));
            break;
        }
        if (privateKeyAlias != null) {
            String cryptoProvider = ServerCrypto.class.getName();
            Properties props = RampartConfigUtil.getServerCryptoProperties((String[])new String[]{keyStoreName}, (String)keyStoreName, privateKeyAlias);
            SAMLTokenIssuerConfig stsSamlConfig = new SAMLTokenIssuerConfig(issuerName, cryptoProvider, props);
            stsSamlConfig.setIssuerKeyAlias(keyAlias);
            stsSamlConfig.setIssuerKeyPassword(keyPassword);
            stsSamlConfig.setAddRequestedAttachedRef(true);
            stsSamlConfig.setAddRequestedUnattachedRef(true);
            stsSamlConfig.setKeyComputation(2);
            stsSamlConfig.setProofKeyType("BinarySecret");
            stsSamlConfig.setCallbackHandlerName(AttributeCallbackHandler.class.getName());
            String resourcePath = null;
            resourcePath = "/repository/axis2/service-groups/wso2carbon-sts/services/wso2carbon-sts/trustedServices";
            if (systemRegistry.resourceExists(resourcePath)) {
                Resource trustedService = null;
                Properties properties = null;
                Iterator<Map.Entry<Object, Object>> iterator = null;
                trustedService = systemRegistry.get(resourcePath);
                properties = trustedService.getProperties();
                if (properties != null && !properties.isEmpty()) {
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        stsSamlConfig.addTrustedServiceEndpointAddress((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
                    }
                }
            }
            return stsSamlConfig;
        }
        return null;
    }
}

