/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sts.passive.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.service.RealmService;

public class IdentityPassiveSTSServiceComponent {
    private static Log log = LogFactory.getLog(IdentityPassiveSTSServiceComponent.class);
    private static UserRealm userRealm = null;
    private static RegistryService registryService;

    protected void activate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Identity Provider bundle is activated");
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Identity Provider bundle is deactivated");
        }
    }

    protected void setUserRealmDelegating(UserRealm userRealmDelegating) {
        if (log.isDebugEnabled()) {
            log.info((Object)"DelegatingUserRealm set in Identity Provider bundle");
        }
        userRealm = userRealmDelegating;
    }

    protected void unsetUserRealmDelegating(UserRealm userRealmDelegating) {
        if (log.isDebugEnabled()) {
            log.info((Object)"DelegatingUserRealm set in Identity Provider bundle");
        }
    }

    protected void unsetUserRealmDefault(RealmService userRealmDefault) {
        if (log.isDebugEnabled()) {
            log.info((Object)"DefaultUserRealm unset in Identity Provider bundle");
        }
    }

    public static UserRealm getRealm() {
        return userRealm;
    }

    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService set in Carbon STS bundle");
        }
        try {
            IdentityPassiveSTSServiceComponent.registryService = registryService;
        }
        catch (Throwable e) {
            log.error((Object)"Failed to get a reference to the Registry", e);
        }
    }

    protected void unsetRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unset in Carbon STS bundle");
        }
        registryService = null;
    }

    public static Registry getGovernanceSystemRegistry() throws RegistryException {
        return registryService.getGovernanceSystemRegistry();
    }

    public static Registry getConfigSystemRegistry() throws RegistryException {
        return registryService.getConfigSystemRegistry();
    }
}

