/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sts.passive.ui.client;

import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.sts.passive.stub.IdentityPassiveSTSServiceStub;
import org.wso2.carbon.identity.sts.passive.stub.types.ClaimDTO;
import org.wso2.carbon.identity.sts.passive.stub.types.RequestToken;
import org.wso2.carbon.identity.sts.passive.stub.types.ResponseToken;

public class IdentityPassiveSTSClient {
    private static final Log log = LogFactory.getLog(IdentityPassiveSTSClient.class);
    private IdentityPassiveSTSServiceStub stub = null;

    public IdentityPassiveSTSClient(String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backendServerURL + "IdentityPassiveSTSService";
        this.stub = new IdentityPassiveSTSServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
    }

    public ResponseToken getResponse(RequestToken request) throws AxisFault {
        try {
            return this.stub.getResponse(request);
        }
        catch (Exception e) {
            this.handleException("Error ouccured getting the response from the backend service", e);
            return null;
        }
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    public void addTrustedService(String realmName, String claimDialect, String claims) throws AxisFault {
        try {
            this.stub.addTrustedService(realmName, claimDialect, claims);
        }
        catch (Exception e) {
            this.handleException("Error occurred while adding the trusted service: " + realmName, e);
        }
    }

    public void removeTrustedService(String realmName) throws AxisFault {
        try {
            this.stub.removeTrustedService(realmName);
        }
        catch (Exception e) {
            this.handleException("Error occurred while removing the trusted service: " + realmName, e);
        }
    }

    public ClaimDTO[] getAllTrustedServices() throws AxisFault {
        try {
            return this.stub.getAllTrustedServices();
        }
        catch (Exception e) {
            this.handleException("Error occurred while getting all trusted services.", e);
            return new ClaimDTO[0];
        }
    }
}

