/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.saml.ui.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.sso.saml.ui.util.SAMLSSOUIUtil;

public class SAMLSSOUIBundleActivator
implements BundleActivator {
    private static Log log = LogFactory.getLog(SAMLSSOUIBundleActivator.class);
    private static int defaultSingleLogoutRetryCount = 5;
    private static long defaultSingleLogoutRetryInterval = 60000L;

    public void start(BundleContext bundleContext) {
        block2: {
            try {
                IdentityUtil.populateProperties();
                SAMLSSOUIUtil.setSingleLogoutRetryCount(Integer.parseInt(IdentityUtil.getProperty((String)"SSOService.SingleLogoutRetryCount")));
                SAMLSSOUIUtil.setSingleLogoutRetryInterval(Long.parseLong(IdentityUtil.getProperty((String)"SSOService.SingleLogoutRetryInterval")));
                log.debug((Object)("Single logout retry count is set to " + SAMLSSOUIUtil.getSingleLogoutRetryCount()));
                log.debug((Object)("Single logout retry interval is set to " + SAMLSSOUIUtil.getSingleLogoutRetryInterval() + " in seconds."));
            }
            catch (Exception e) {
                SAMLSSOUIUtil.setSingleLogoutRetryCount(defaultSingleLogoutRetryCount);
                SAMLSSOUIUtil.setSingleLogoutRetryInterval(defaultSingleLogoutRetryInterval);
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)("Failed to activate SAMLSSOUIBundle Activator, which load the single logout retry count and interval values. And default values for retry count: " + defaultSingleLogoutRetryCount + " and interval: " + defaultSingleLogoutRetryInterval + " will be used."));
            }
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }
}

