/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.saml.ui;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.sso.saml.stub.IdentityException;
import org.wso2.carbon.identity.sso.saml.stub.types.SAMLSSOAuthnReqDTO;
import org.wso2.carbon.identity.sso.saml.stub.types.SAMLSSOReqValidationResponseDTO;
import org.wso2.carbon.identity.sso.saml.stub.types.SAMLSSORespDTO;
import org.wso2.carbon.identity.sso.saml.ui.client.SAMLSSOServiceClient;
import org.wso2.carbon.identity.sso.saml.ui.logout.LogoutRequestSender;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class SAMLSSOProvider
extends HttpServlet {
    private static Log log = LogFactory.getLog(SAMLSSOProvider.class);
    private static final int SSO_SESSION_EXPIRE = 36000;

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doPost(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String username = req.getParameter("username");
        String password = req.getParameter("password");
        HttpSession session = req.getSession();
        String ssoTokenID = session.getId();
        Cookie tokenCookie = this.getSSOTokenCookie(req);
        if (tokenCookie != null) {
            ssoTokenID = tokenCookie.getValue();
        }
        try {
            if (username == null && password == null) {
                String relayState;
                String samlRequest = req.getParameter("SAMLRequest");
                String authMode = "usernamePasswordBasedAuthn";
                if (req.getParameter("authMode") != null && "openIDBasedAuthn".equals(req.getParameter("authMode"))) {
                    authMode = "openIDBasedAuthn";
                }
                if ((relayState = req.getParameter("RelayState")) == null) {
                    log.warn((Object)"RelayState is not present in the request.");
                    req.setAttribute("status", (Object)"RealyState is not present in the request.");
                    req.setAttribute("statusMsg", (Object)"This request will not be processed further.");
                    RequestDispatcher reqDispatcher = this.getServletContext().getRequestDispatcher("/carbon/sso-saml/notification_ajaxprocessor.jsp");
                    reqDispatcher.forward((ServletRequest)req, (ServletResponse)resp);
                    return;
                }
                if (samlRequest != null) {
                    this.handleSAMLRequest(req, resp, ssoTokenID, samlRequest, relayState, authMode);
                } else {
                    this.handleLogout(req, resp);
                }
            } else {
                this.handleRequestFromLoginPage(req, resp, ssoTokenID);
            }
        }
        catch (IdentityException e) {
            log.error((Object)"Error when processing the authentication request!", (Throwable)e);
            req.setAttribute("status", (Object)"Error when processing the authentication request!");
            req.setAttribute("statusMsg", (Object)"Please try login again.");
            RequestDispatcher reqDispatcher = this.getServletContext().getRequestDispatcher("/carbon/sso-saml/notification_ajaxprocessor.jsp");
            reqDispatcher.forward((ServletRequest)req, (ServletResponse)resp);
        }
    }

    private void handleRequestFromLoginPage(HttpServletRequest req, HttpServletResponse resp, String ssoTokenID) throws IdentityException, IOException, ServletException {
        String relayState = req.getParameter("RelayState");
        HttpSession session = req.getSession();
        String serverURL = CarbonUIUtil.getServerURL((ServletContext)session.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)session.getServletContext().getAttribute("ConfigurationContext");
        SAMLSSOServiceClient ssoServiceClient = new SAMLSSOServiceClient(serverURL, configContext);
        SAMLSSOAuthnReqDTO authnReqDTO = new SAMLSSOAuthnReqDTO();
        this.populateAuthnReqDTO(req, authnReqDTO);
        SAMLSSORespDTO authRespDTO = ssoServiceClient.authenticate(authnReqDTO, ssoTokenID);
        if (authRespDTO.getSessionEstablished()) {
            this.storeSSOTokenCookie(ssoTokenID, req, resp);
            req.setAttribute("RelayState", (Object)relayState);
            req.setAttribute("assertionString", (Object)authRespDTO.getRespString());
            req.setAttribute("assertnConsumerURL", (Object)authRespDTO.getAssertionConsumerURL());
            resp.setHeader("tenantDomain", MultitenantUtils.getTenantDomain((String)authRespDTO.getSubject()));
            RequestDispatcher reqDispatcher = this.getServletContext().getRequestDispatcher("/carbon/sso-saml/redirect_ajaxprocessor.jsp");
            reqDispatcher.forward((ServletRequest)req, (ServletResponse)resp);
        } else {
            req.setAttribute("authFailure", (Object)Boolean.parseBoolean("true"));
            req.setAttribute("authFailureMsg", (Object)authRespDTO.getErrorMsg());
            this.populateReAuthenticationRequest(req);
            String forwardingPath = this.getLoginPage(authRespDTO.getLoginPageURL());
            RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(forwardingPath);
            dispatcher.forward((ServletRequest)req, (ServletResponse)resp);
        }
    }

    private void populateAuthnReqDTO(HttpServletRequest req, SAMLSSOAuthnReqDTO authnReqDTO) {
        authnReqDTO.setAssertionConsumerURL(this.getRequestParameter(req, "assertnConsumerURL"));
        authnReqDTO.setId(this.getRequestParameter(req, "id"));
        authnReqDTO.setIssuer(this.getRequestParameter(req, "issuer"));
        authnReqDTO.setUsername(this.getRequestParameter(req, "username"));
        authnReqDTO.setPassword(this.getRequestParameter(req, "password"));
        authnReqDTO.setSubject(this.getRequestParameter(req, "subject"));
        authnReqDTO.setRpSessionId(this.getRequestParameter(req, "relyingPartySessionId"));
        authnReqDTO.setAssertionString(this.getRequestParameter(req, "assertionString"));
    }

    private void handleLogout(HttpServletRequest req, HttpServletResponse resp) throws IdentityException, IOException, ServletException {
        req.setAttribute("status", (Object)"You have been successfully signed out.");
        req.setAttribute("statusMsg", (Object)"All the other authenticated sessions are terminated.");
        RequestDispatcher reqDispatcher = this.getServletContext().getRequestDispatcher("/carbon/sso-saml/notification_ajaxprocessor.jsp");
        reqDispatcher.forward((ServletRequest)req, (ServletResponse)resp);
    }

    private void handleSAMLRequest(HttpServletRequest req, HttpServletResponse resp, String ssoTokenID, String samlRequest, String relayState, String authMode) throws IdentityException, IOException, ServletException {
        ConfigurationContext configContext;
        String rpSessionId = req.getParameter("SSOAuthSessionID");
        HttpSession session = req.getSession();
        String serverURL = CarbonUIUtil.getServerURL((ServletContext)session.getServletContext(), (HttpSession)session);
        SAMLSSOServiceClient ssoServiceClient = new SAMLSSOServiceClient(serverURL, configContext = (ConfigurationContext)session.getServletContext().getAttribute("ConfigurationContext"));
        SAMLSSOReqValidationResponseDTO signInRespDTO = ssoServiceClient.validate(samlRequest, ssoTokenID, rpSessionId, authMode);
        if (!signInRespDTO.getLogOutReq()) {
            if (signInRespDTO.getValid() && signInRespDTO.getResponse() == null) {
                this.populateLoginPageRequest(req, signInRespDTO);
                req.setAttribute("RelayState", (Object)relayState);
                String forwardingPath = this.getLoginPage(signInRespDTO.getLoginPageURL());
                RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(forwardingPath);
                dispatcher.forward((ServletRequest)req, (ServletResponse)resp);
            } else if (signInRespDTO.getResponse() != null) {
                req.setAttribute("RelayState", (Object)relayState);
                req.setAttribute("assertionString", (Object)signInRespDTO.getResponse());
                req.setAttribute("assertnConsumerURL", (Object)signInRespDTO.getAssertionConsumerURL());
                resp.setHeader("tenantDomain", MultitenantUtils.getTenantDomain((String)signInRespDTO.getSubject()));
                if ("openIDBasedAuthn".equals(authMode)) {
                    this.storeSSOTokenCookie(ssoTokenID, req, resp);
                }
                RequestDispatcher reqDispatcher = this.getServletContext().getRequestDispatcher("/carbon/sso-saml/redirect_ajaxprocessor.jsp");
                reqDispatcher.forward((ServletRequest)req, (ServletResponse)resp);
            }
        } else {
            LogoutRequestSender.getInstance().sendLogoutRequests(signInRespDTO.getLogoutRespDTO());
            req.setAttribute("RelayState", (Object)relayState);
            req.setAttribute("assertionString", (Object)signInRespDTO.getLogoutResponse());
            req.setAttribute("assertnConsumerURL", (Object)signInRespDTO.getAssertionConsumerURL());
            RequestDispatcher reqDispatcher = this.getServletContext().getRequestDispatcher("/carbon/sso-saml/redirect_ajaxprocessor.jsp");
            reqDispatcher.forward((ServletRequest)req, (ServletResponse)resp);
        }
    }

    private void populateLoginPageRequest(HttpServletRequest req, SAMLSSOReqValidationResponseDTO signInRespDTO) {
        req.setAttribute("issuer", (Object)signInRespDTO.getIssuer());
        req.setAttribute("assertnConsumerURL", (Object)signInRespDTO.getAssertionConsumerURL());
        req.setAttribute("id", (Object)signInRespDTO.getId());
        req.setAttribute("subject", (Object)signInRespDTO.getSubject());
        req.setAttribute("relyingPartySessionId", (Object)signInRespDTO.getRpSessionId());
        req.setAttribute("assertionString", (Object)signInRespDTO.getAssertionString());
    }

    private void populateReAuthenticationRequest(HttpServletRequest req) {
        req.setAttribute("issuer", (Object)req.getParameter("issuer"));
        req.setAttribute("assertnConsumerURL", (Object)req.getParameter("assertnConsumerURL"));
        req.setAttribute("id", (Object)req.getParameter("id"));
        req.setAttribute("subject", (Object)req.getParameter("subject"));
        req.setAttribute("relyingPartySessionId", (Object)req.getParameter("relyingPartySessionId"));
        req.setAttribute("assertionString", (Object)req.getParameter("assertionString"));
    }

    private String getAdminConsoleURL(HttpServletRequest request) {
        String url = CarbonUIUtil.getAdminConsoleURL((HttpServletRequest)request);
        if (url.contains("/samlsso")) {
            url = url.replace("/samlsso", "");
        }
        return url;
    }

    private Cookie getSSOTokenCookie(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals("ssoTokenId")) continue;
                return cookie;
            }
        }
        return null;
    }

    private void storeSSOTokenCookie(String ssoTokenID, HttpServletRequest req, HttpServletResponse resp) {
        Cookie ssoTokenCookie = this.getSSOTokenCookie(req);
        if (ssoTokenCookie == null) {
            ssoTokenCookie = new Cookie("ssoTokenId", ssoTokenID);
        }
        ssoTokenCookie.setMaxAge(36000);
        resp.addCookie(ssoTokenCookie);
    }

    private String getLoginPage(String customLoginPage) {
        if (customLoginPage != null) {
            return "/carbon/" + customLoginPage.trim();
        }
        return "/carbon/sso-saml/login_ajaxprocessor.jsp";
    }

    private String getRequestParameter(HttpServletRequest req, String paramName) {
        if (req.getParameter(paramName) != null && req.getParameter(paramName).equals("null")) {
            return null;
        }
        return req.getParameter(paramName);
    }
}

