/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.saml.ui;

import java.io.ByteArrayOutputStream;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.DefaultBootstrap;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.Status;
import org.opensaml.saml2.core.StatusCode;
import org.opensaml.saml2.core.StatusMessage;
import org.opensaml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml2.core.impl.ResponseBuilder;
import org.opensaml.saml2.core.impl.StatusBuilder;
import org.opensaml.saml2.core.impl.StatusCodeBuilder;
import org.opensaml.saml2.core.impl.StatusMessageBuilder;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallerFactory;
import org.opensaml.xml.util.Base64;
import org.w3c.dom.Element;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.wso2.carbon.identity.base.IdentityException;

public class ErrorResponseBuilder {
    private static Log log = LogFactory.getLog(ErrorResponseBuilder.class);

    public static String generateErrorneousResponse() {
        Response response = new ResponseBuilder().buildObject();
        response.setIssuer(ErrorResponseBuilder.getIssuer());
        response.setStatus(ErrorResponseBuilder.buildStatus());
        response.setVersion(SAMLVersion.VERSION_20);
        response.setID(UUIDGenerator.getUUID());
        try {
            return ErrorResponseBuilder.encode(ErrorResponseBuilder.marshall((XMLObject)response));
        }
        catch (IdentityException e) {
            return null;
        }
    }

    private static Status buildStatus() {
        Status stat = new StatusBuilder().buildObject();
        StatusCode statCode = new StatusCodeBuilder().buildObject();
        statCode.setValue("urn:oasis:names:tc:SAML:2.0:status:Responder");
        stat.setStatusCode(statCode);
        StatusMessage statMesssage = new StatusMessageBuilder().buildObject();
        statMesssage.setMessage("Error when processing the Authentication Request");
        stat.setStatusMessage(statMesssage);
        return stat;
    }

    private static String marshall(XMLObject xmlObject) throws IdentityException {
        try {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            MarshallerFactory marshallerFactory = Configuration.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller(xmlObject);
            Element element = marshaller.marshall(xmlObject);
            ByteArrayOutputStream byteArrayOutputStrm = new ByteArrayOutputStream();
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            LSOutput output = impl.createLSOutput();
            output.setByteStream(byteArrayOutputStrm);
            writer.write(element, output);
            return byteArrayOutputStrm.toString();
        }
        catch (Exception e) {
            log.error((Object)"Error Serializing the SAML Response");
            throw new IdentityException("Error Serializing the SAML Response", (Throwable)e);
        }
    }

    private static Issuer getIssuer() {
        Issuer issuer = new IssuerBuilder().buildObject();
        issuer.setValue("WSO2 Identity Server");
        issuer.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        return issuer;
    }

    public static String encode(String authReq) {
        return new String(Base64.encodeBytes((byte[])authReq.getBytes()));
    }

    static {
        try {
            DefaultBootstrap.bootstrap();
        }
        catch (ConfigurationException e) {
            log.error((Object)"Errors when bootstrapping the OpenSAML2 library", (Throwable)e);
        }
    }
}

