/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.saml.ui.client;

import java.util.ArrayList;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.sso.saml.stub.IdentitySAMLSSOConfigServiceStub;
import org.wso2.carbon.identity.sso.saml.stub.types.SAMLSSOServiceProviderDTO;
import org.wso2.carbon.identity.sso.saml.stub.types.SAMLSSOServiceProviderInfoDTO;

public class SAMLSSOConfigServiceClient {
    private static Log log = LogFactory.getLog(SAMLSSOConfigServiceClient.class);
    private IdentitySAMLSSOConfigServiceStub stub;

    public SAMLSSOConfigServiceClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        try {
            String serviceURL = backendServerURL + "IdentitySAMLSSOConfigService";
            this.stub = new IdentitySAMLSSOConfigServiceStub(configCtx, serviceURL);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault ex) {
            log.error((Object)"Error generating stub for IdentitySAMLSSOConfigService", (Throwable)ex);
            throw new AxisFault("Error generating stub for IdentitySAMLSSOConfigService", (Throwable)ex);
        }
    }

    public boolean addServiceProvider(SAMLSSOServiceProviderDTO serviceProviderDTO) throws AxisFault {
        boolean status = false;
        try {
            status = this.stub.addRPServiceProvider(serviceProviderDTO);
        }
        catch (Exception e) {
            log.error((Object)"Error adding a new Service Provider", (Throwable)e);
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
        return status;
    }

    public SAMLSSOServiceProviderInfoDTO getRegisteredServiceProviders() throws AxisFault {
        try {
            return this.stub.getServiceProviders();
        }
        catch (Exception e) {
            log.error((Object)"Error retrieving service provider information", (Throwable)e);
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
    }

    public ArrayList<String> getCertAlias() throws AxisFault {
        ArrayList<String> certAliasList = new ArrayList<String>();
        try {
            String[] certAliases;
            for (String alias : certAliases = this.stub.getCertAliasOfPrimaryKeyStore()) {
                certAliasList.add(alias);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error retrieving Cert Aliases", (Throwable)e);
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
        return certAliasList;
    }

    public boolean removeServiceProvier(String issuerName) throws AxisFault {
        try {
            return this.stub.removeServiceProvider(issuerName);
        }
        catch (Exception e) {
            log.error((Object)"Error when removing the service provider", (Throwable)e);
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
    }
}

