/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.saml.ui.session.mgt;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.sso.saml.ui.session.mgt.FESessionBean;

public class FESessionManager {
    private static FESessionManager sessionManager = new FESessionManager();
    private static SecureRandom secureRandomInstance;
    private static MessageDigest messageDigest;
    private static Log log;
    public ConcurrentHashMap<String, FESessionBean> sessionMap = new ConcurrentHashMap();

    private static void initialize() {
        try {
            secureRandomInstance = SecureRandom.getInstance("SHA1PRNG");
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)"Error when initializing the SAML2 SSO FESessionManager.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private FESessionManager() {
    }

    public static FESessionManager getInstance() {
        if (sessionManager == null) {
            sessionManager = new FESessionManager();
        }
        return sessionManager;
    }

    public FESessionBean getFESessionBean(String sessionID) {
        if (this.sessionMap.containsKey(sessionID)) {
            return this.sessionMap.get(sessionID);
        }
        return null;
    }

    public String addNewSession(FESessionBean sessionBean) {
        String sessionId = this.generateSessionId();
        this.sessionMap.put(sessionId, sessionBean);
        return sessionId;
    }

    public void removeSession(String sessionId) {
        if (this.sessionMap.containsKey(sessionId)) {
            this.sessionMap.remove(sessionId);
        } else {
            log.warn((Object)("The session bean with the ID : " + sessionId + "is not available in the session map"));
        }
    }

    private String generateSessionId() {
        String randomNum = new Integer(secureRandomInstance.nextInt()).toString();
        byte[] result = messageDigest.digest(randomNum.getBytes());
        return this.hexEncode(result);
    }

    private String hexEncode(byte[] digestValue) {
        StringBuilder result = new StringBuilder();
        char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        for (int idx = 0; idx < digestValue.length; ++idx) {
            byte b = digestValue[idx];
            result.append(digits[(b & 0xF0) >> 4]);
            result.append(digits[b & 0xF]);
        }
        return result.toString();
    }

    static {
        log = LogFactory.getLog(FESessionManager.class);
        FESessionManager.initialize();
    }
}

