/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.saml.ui.logout;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.wso2.carbon.identity.sso.saml.stub.types.SingleLogoutRequestDTO;
import org.wso2.carbon.identity.sso.saml.ui.util.SAMLSSOUIUtil;

public class LogoutRequestSender {
    private static Log log = LogFactory.getLog(LogoutRequestSender.class);
    private static ExecutorService threadPool = Executors.newFixedThreadPool(2);
    private static LogoutRequestSender instance = new LogoutRequestSender();

    private LogoutRequestSender() {
    }

    public static LogoutRequestSender getInstance() {
        return instance;
    }

    public void sendLogoutRequests(SingleLogoutRequestDTO[] logoutReqs) {
        if (logoutReqs == null) {
            return;
        }
        for (SingleLogoutRequestDTO reqDTO : logoutReqs) {
            threadPool.submit(new LogoutReqSenderTask(reqDTO));
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)"A logoutReqSenderTask is assigned to the thread pool");
        }
    }

    private int derivePortFromAssertionConsumerURL(String assertionConsumerURL) throws URISyntaxException {
        int port = 443;
        try {
            URI uri = new URI(assertionConsumerURL);
            if (uri.getPort() != -1) {
                port = uri.getPort();
            } else if ("http".equals(uri.getScheme())) {
                port = 80;
            }
        }
        catch (URISyntaxException e) {
            log.error((Object)"Error deriving port from the assertion consumer url", (Throwable)e);
            throw e;
        }
        return port;
    }

    private class LogoutReqSenderTask
    implements Runnable {
        private SingleLogoutRequestDTO logoutReqDTO;

        public LogoutReqSenderTask(SingleLogoutRequestDTO logoutReqDTO) {
            this.logoutReqDTO = logoutReqDTO;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<BasicNameValuePair> logoutReqParams = new ArrayList<BasicNameValuePair>();
            logoutReqParams.add(new BasicNameValuePair("SAMLRequest", this.logoutReqDTO.getLogoutResponse()));
            try {
                int port = LogoutRequestSender.this.derivePortFromAssertionConsumerURL(this.logoutReqDTO.getAssertionConsumerURL());
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(logoutReqParams, "UTF-8");
                HttpPost httpPost = new HttpPost(this.logoutReqDTO.getAssertionConsumerURL());
                httpPost.setEntity((HttpEntity)entity);
                httpPost.addHeader("Cookie", "JSESSIONID=" + this.logoutReqDTO.getRpSessionId());
                X509TrustManager easyTrustManager = new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }
                };
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, new TrustManager[]{easyTrustManager}, null);
                SSLSocketFactory sf = new SSLSocketFactory(sslContext);
                sf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                Scheme httpsScheme = new Scheme("https", (SocketFactory)sf, port);
                DefaultHttpClient httpClient = new DefaultHttpClient();
                httpClient.getConnectionManager().getSchemeRegistry().register(httpsScheme);
                HttpResponse response = null;
                boolean isSuccessfullyLogout = false;
                for (int currentRetryCount = 0; currentRetryCount < SAMLSSOUIUtil.getSingleLogoutRetryCount(); ++currentRetryCount) {
                    int statusCode = 0;
                    try {
                        response = httpClient.execute((HttpUriRequest)httpPost);
                        statusCode = response.getStatusLine().getStatusCode();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    if (response != null && SAMLSSOUIUtil.isHttpSuccessStatusCode(statusCode)) {
                        log.info((Object)("single logout request is sent to : " + this.logoutReqDTO.getAssertionConsumerURL() + " is returned with " + HttpStatus.getStatusText((int)response.getStatusLine().getStatusCode())));
                        isSuccessfullyLogout = true;
                        break;
                    }
                    if (statusCode != 0) {
                        log.warn((Object)("Failed single logout response from " + this.logoutReqDTO.getAssertionConsumerURL() + " with status code " + HttpStatus.getStatusText((int)statusCode)));
                    }
                    try {
                        Thread e = Thread.currentThread();
                        synchronized (e) {
                            Thread.currentThread().wait(SAMLSSOUIUtil.getSingleLogoutRetryInterval());
                        }
                        log.info((Object)("Sending single log out request again with retry count " + (currentRetryCount + 1) + " after waiting for " + SAMLSSOUIUtil.getSingleLogoutRetryInterval() + " milli seconds to " + this.logoutReqDTO.getAssertionConsumerURL()));
                        continue;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (!isSuccessfullyLogout) {
                    log.error((Object)("Single logout failed after retrying " + SAMLSSOUIUtil.getSingleLogoutRetryCount() + " times with time interval " + SAMLSSOUIUtil.getSingleLogoutRetryInterval() + " in milli seconds."));
                }
            }
            catch (IOException e) {
                log.error((Object)("Error sending logout requests to : " + this.logoutReqDTO.getAssertionConsumerURL()), (Throwable)e);
            }
            catch (GeneralSecurityException e) {
                log.error((Object)"Error registering the EasySSLProtocolSocketFactory", (Throwable)e);
            }
            catch (RuntimeException e) {
                log.error((Object)"Runtime exception occurred.", (Throwable)e);
            }
            catch (URISyntaxException e) {
                log.error((Object)"Error deriving port from the assertion consumer url", (Throwable)e);
            }
        }
    }
}

