/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.common;

import java.util.List;
import org.joda.time.DateTime;
import org.opensaml.saml2.common.CacheableSAMLObject;
import org.opensaml.saml2.common.TimeBoundSAMLObject;
import org.opensaml.xml.XMLObject;

public class SAML2Helper {
    public static boolean isValid(XMLObject xmlObject) {
        TimeBoundSAMLObject timeBoundObject;
        if (xmlObject instanceof TimeBoundSAMLObject && !(timeBoundObject = (TimeBoundSAMLObject)xmlObject).isValid()) {
            return false;
        }
        XMLObject parent = xmlObject.getParent();
        if (parent != null) {
            return SAML2Helper.isValid(parent);
        }
        return true;
    }

    public static DateTime getEarliestExpiration(XMLObject xmlObject) {
        DateTime now = new DateTime();
        return SAML2Helper.getEarliestExpiration(xmlObject, null, now);
    }

    public static DateTime getEarliestExpiration(XMLObject xmlObject, DateTime earliestExpiration, DateTime now) {
        List<XMLObject> children;
        DateTime elementExpirationTime;
        CacheableSAMLObject cacheInfo;
        if (xmlObject instanceof CacheableSAMLObject && (cacheInfo = (CacheableSAMLObject)xmlObject).getCacheDuration() != null && cacheInfo.getCacheDuration() > 0L) {
            elementExpirationTime = now.plus(cacheInfo.getCacheDuration());
            if (earliestExpiration == null) {
                earliestExpiration = elementExpirationTime;
            } else if (elementExpirationTime != null && elementExpirationTime.isBefore(earliestExpiration)) {
                earliestExpiration = elementExpirationTime;
            }
        }
        if (xmlObject instanceof TimeBoundSAMLObject) {
            TimeBoundSAMLObject timeBoundObject = (TimeBoundSAMLObject)xmlObject;
            elementExpirationTime = timeBoundObject.getValidUntil();
            if (earliestExpiration == null) {
                earliestExpiration = elementExpirationTime;
            } else if (elementExpirationTime != null && elementExpirationTime.isBefore(earliestExpiration)) {
                earliestExpiration = elementExpirationTime;
            }
        }
        if ((children = xmlObject.getOrderedChildren()) != null) {
            for (XMLObject child : xmlObject.getOrderedChildren()) {
                if (child == null) continue;
                earliestExpiration = SAML2Helper.getEarliestExpiration(child, earliestExpiration, now);
            }
        }
        return earliestExpiration;
    }
}

