/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.opensaml.saml1.binding.artifact.SAML1ArtifactBuilderFactory;
import org.opensaml.saml2.binding.artifact.SAML2ArtifactBuilderFactory;

public class Configuration
extends org.opensaml.xml.Configuration {
    private static String defaultDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static DateTimeFormatter dateFormatter;
    private static SAML1ArtifactBuilderFactory saml1ArtifactBuilderFactory;
    private static SAML2ArtifactBuilderFactory saml2ArtifactBuilderFactory;

    public static DateTimeFormatter getSAMLDateFormatter() {
        if (dateFormatter == null) {
            DateTimeFormatter formatter = DateTimeFormat.forPattern(defaultDateFormat);
            dateFormatter = formatter.withChronology(ISOChronology.getInstanceUTC());
        }
        return dateFormatter;
    }

    public static void setSAMLDateFormat(String format) {
        DateTimeFormatter formatter = DateTimeFormat.forPattern(format);
        dateFormatter = formatter.withChronology(ISOChronology.getInstanceUTC());
    }

    public static SAML1ArtifactBuilderFactory getSAML1ArtifactBuilderFactory() {
        return saml1ArtifactBuilderFactory;
    }

    public static void setSAML1ArtifactBuilderFactory(SAML1ArtifactBuilderFactory factory) {
        saml1ArtifactBuilderFactory = factory;
    }

    public static SAML2ArtifactBuilderFactory getSAML2ArtifactBuilderFactory() {
        return saml2ArtifactBuilderFactory;
    }

    public static void setSAML2ArtifactBuilderFactory(SAML2ArtifactBuilderFactory factory) {
        saml2ArtifactBuilderFactory = factory;
    }
}

