/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.saml.validators;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.Subject;
import org.opensaml.xml.XMLObject;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.model.SAMLSSOServiceProviderDO;
import org.wso2.carbon.identity.sso.saml.SSOServiceProviderConfigManager;
import org.wso2.carbon.identity.sso.saml.builders.ErrorResponseBuilder;
import org.wso2.carbon.identity.sso.saml.dto.SAMLSSOReqValidationResponseDTO;
import org.wso2.carbon.identity.sso.saml.util.SAMLSSOUtil;

public class AuthnRequestValidator {
    private static Log log = LogFactory.getLog(AuthnRequestValidator.class);
    AuthnRequest authnReq;

    public AuthnRequestValidator(AuthnRequest authnReq) throws IdentityException {
        this.authnReq = authnReq;
    }

    public SAMLSSOReqValidationResponseDTO validate() throws IdentityException {
        try {
            SAMLSSOReqValidationResponseDTO validationResponse = new SAMLSSOReqValidationResponseDTO();
            Issuer issuer = this.authnReq.getIssuer();
            Subject subject = this.authnReq.getSubject();
            if (!this.authnReq.getVersion().equals(SAMLVersion.VERSION_20)) {
                String errorResp = this.buildErrorResponse("urn:oasis:names:tc:SAML:2.0:status:VersionMismatch", "Invalid SAML Version in Authentication Request. SAML Version should be equal to 2.0");
                validationResponse.setResponse(errorResp);
                validationResponse.setValid(false);
                return validationResponse;
            }
            if (issuer.getValue() != null) {
                validationResponse.setIssuer(issuer.getValue());
            } else if (issuer.getSPProvidedID() != null) {
                validationResponse.setIssuer(issuer.getSPProvidedID());
            } else {
                validationResponse.setValid(false);
                String errorResp = this.buildErrorResponse("urn:oasis:names:tc:SAML:2.0:status:Requester", "Issuer/ProviderName should not be empty in the Authentication Request.");
                validationResponse.setResponse(errorResp);
                validationResponse.setValid(false);
                return validationResponse;
            }
            SSOServiceProviderConfigManager spConfigManager = SSOServiceProviderConfigManager.getInstance();
            SAMLSSOServiceProviderDO spDO = spConfigManager.getServiceProvider(issuer.getValue());
            if (spDO != null) {
                validationResponse.setLoginPageURL(spDO.getLoginPageURL());
            }
            if (subject != null && subject.getNameID() != null) {
                validationResponse.setSubject(subject.getNameID().getValue());
            }
            validationResponse.setId(this.authnReq.getID());
            validationResponse.setAssertionConsumerURL(this.authnReq.getAssertionConsumerServiceURL());
            validationResponse.setValid(true);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Authentication Request Validation is successfull..");
            }
            return validationResponse;
        }
        catch (Exception e) {
            throw new IdentityException("Error validating the authentication request", (Throwable)e);
        }
    }

    private String buildErrorResponse(String status, String message) throws Exception {
        ErrorResponseBuilder respBuilder = new ErrorResponseBuilder();
        Response response = respBuilder.buildResponse(this.authnReq.getID(), status, message);
        return SAMLSSOUtil.encode(SAMLSSOUtil.marshall((XMLObject)response));
    }
}

