/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.saml.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Random;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.opensaml.Configuration;
import org.opensaml.DefaultBootstrap;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.RequestAbstractType;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.impl.IssuerBuilder;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallerFactory;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.x509.X509Credential;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureValidator;
import org.opensaml.xml.signature.Signer;
import org.opensaml.xml.signature.X509Certificate;
import org.opensaml.xml.signature.X509Data;
import org.opensaml.xml.validation.ValidationException;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.sso.saml.builders.X509CredentialImpl;
import org.wso2.carbon.identity.sso.saml.exception.IdentitySAML2SSOException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.ConfigurationContextService;

public class SAMLSSOUtil {
    private static Log log = LogFactory.getLog(SAMLSSOUtil.class);
    private static RegistryService registryService;
    private static BundleContext bundleContext;
    private static RealmService realmService;
    private static ConfigurationContextService configCtxService;
    private static boolean isBootStrapped;
    private static Random random;
    private static final char[] charMapping;

    public static void setRegistryService(RegistryService registryService) {
        SAMLSSOUtil.registryService = registryService;
    }

    public static void setRealmService(RealmService realmService) {
        SAMLSSOUtil.realmService = realmService;
    }

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    public static void setBundleContext(BundleContext bundleContext) {
        SAMLSSOUtil.bundleContext = bundleContext;
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    public static RealmService getRealmService() {
        return realmService;
    }

    public static ConfigurationContextService getConfigCtxService() {
        return configCtxService;
    }

    public static void setConfigCtxService(ConfigurationContextService configCtxService) {
        SAMLSSOUtil.configCtxService = configCtxService;
    }

    public static XMLObject unmarshall(String authReqStr) throws IdentityException {
        try {
            SAMLSSOUtil.doBootstrap();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = docBuilder.parse(new ByteArrayInputStream(authReqStr.trim().getBytes()));
            Element element = document.getDocumentElement();
            UnmarshallerFactory unmarshallerFactory = Configuration.getUnmarshallerFactory();
            Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(element);
            return unmarshaller.unmarshall(element);
        }
        catch (Exception e) {
            log.error((Object)"Error in constructing AuthRequest from the encoded String", (Throwable)e);
            throw new IdentityException("Error in constructing AuthRequest from the encoded String ", (Throwable)e);
        }
    }

    public static String marshall(XMLObject xmlObject) throws IdentityException {
        try {
            SAMLSSOUtil.doBootstrap();
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            MarshallerFactory marshallerFactory = org.opensaml.xml.Configuration.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller(xmlObject);
            Element element = marshaller.marshall(xmlObject);
            ByteArrayOutputStream byteArrayOutputStrm = new ByteArrayOutputStream();
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            LSOutput output = impl.createLSOutput();
            output.setByteStream(byteArrayOutputStrm);
            writer.write(element, output);
            return byteArrayOutputStrm.toString();
        }
        catch (Exception e) {
            log.error((Object)"Error Serializing the SAML Response");
            throw new IdentityException("Error Serializing the SAML Response", (Throwable)e);
        }
    }

    public static String encode(String xmlString) throws Exception {
        xmlString = xmlString.replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replace("\n", "");
        return xmlString;
    }

    public static String decode(String encodedStr) throws IdentityException {
        try {
            Base64 base64Decoder = new Base64();
            byte[] xmlBytes = encodedStr.getBytes("UTF-8");
            byte[] base64DecodedByteArray = base64Decoder.decode(xmlBytes);
            try {
                Inflater inflater = new Inflater(true);
                inflater.setInput(base64DecodedByteArray);
                byte[] xmlMessageBytes = new byte[5000];
                int resultLength = inflater.inflate(xmlMessageBytes);
                if (inflater.getRemaining() > 0) {
                    throw new RuntimeException("didn't allocate enough space to hold decompressed data");
                }
                inflater.end();
                return new String(xmlMessageBytes, 0, resultLength, "UTF-8");
            }
            catch (DataFormatException e) {
                ByteArrayInputStream bais = new ByteArrayInputStream(base64DecodedByteArray);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                InflaterInputStream iis = new InflaterInputStream(bais);
                byte[] buf = new byte[1024];
                int count = iis.read(buf);
                while (count != -1) {
                    baos.write(buf, 0, count);
                    count = iis.read(buf);
                }
                iis.close();
                String decodedStr = new String(baos.toByteArray());
                return decodedStr;
            }
        }
        catch (IOException e) {
            throw new IdentityException("Error when decoding the SAML Request.", (Throwable)e);
        }
    }

    public static Issuer getIssuer() {
        Issuer issuer = new IssuerBuilder().buildObject();
        issuer.setValue(IdentityUtil.getProperty((String)"SSOService.IdentityProviderURL"));
        issuer.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        return issuer;
    }

    public static void doBootstrap() {
        if (!isBootStrapped) {
            try {
                DefaultBootstrap.bootstrap();
                isBootStrapped = true;
            }
            catch (ConfigurationException e) {
                log.error((Object)"Error in bootstrapping the OpenSAML2 library", (Throwable)e);
            }
        }
    }

    public static Response setSignature(Response response, String signatureAlgorithm, X509Credential cred) throws IdentityException {
        SAMLSSOUtil.doBootstrap();
        try {
            Signature signature = (Signature)SAMLSSOUtil.buildXMLObject(Signature.DEFAULT_ELEMENT_NAME);
            signature.setSigningCredential((Credential)cred);
            signature.setSignatureAlgorithm(signatureAlgorithm);
            signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
            try {
                KeyInfo keyInfo = (KeyInfo)SAMLSSOUtil.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
                X509Data data = (X509Data)SAMLSSOUtil.buildXMLObject(X509Data.DEFAULT_ELEMENT_NAME);
                X509Certificate cert = (X509Certificate)SAMLSSOUtil.buildXMLObject(X509Certificate.DEFAULT_ELEMENT_NAME);
                String value = org.apache.xml.security.utils.Base64.encode((byte[])cred.getEntityCertificate().getEncoded());
                cert.setValue(value);
                data.getX509Certificates().add(cert);
                keyInfo.getX509Datas().add(data);
                signature.setKeyInfo(keyInfo);
            }
            catch (CertificateEncodingException e) {
                throw new IdentityException("errorGettingCert");
            }
            response.setSignature(signature);
            ArrayList<Signature> signatureList = new ArrayList<Signature>();
            signatureList.add(signature);
            MarshallerFactory marshallerFactory = org.opensaml.xml.Configuration.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller((XMLObject)response);
            marshaller.marshall((XMLObject)response);
            Init.init();
            Signer.signObjects(signatureList);
            return response;
        }
        catch (Exception e) {
            throw new IdentityException("Error When signing the assertion.", (Throwable)e);
        }
    }

    private static XMLObject buildXMLObject(QName objectQName) throws IdentityException {
        XMLObjectBuilder builder = org.opensaml.xml.Configuration.getBuilderFactory().getBuilder(objectQName);
        if (builder == null) {
            throw new IdentityException("Unable to retrieve builder for object QName " + objectQName);
        }
        return builder.buildObject(objectQName.getNamespaceURI(), objectQName.getLocalPart(), objectQName.getPrefix());
    }

    public static String createID() {
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        char[] chars = new char[40];
        for (int i = 0; i < bytes.length; ++i) {
            int left = bytes[i] >> 4 & 0xF;
            int right = bytes[i] & 0xF;
            chars[i * 2] = charMapping[left];
            chars[i * 2 + 1] = charMapping[right];
        }
        return String.valueOf(chars);
    }

    public static String generateKSNameFromDomainName(String tenantDomain) {
        String ksName = tenantDomain.trim().replace(".", "-");
        return ksName + ".jks";
    }

    public static X509CredentialImpl getX509CredentialImplForTenant(String domainName, String alias) throws IdentitySAML2SSOException {
        int tenantID = 0;
        RegistryService registryService = SAMLSSOUtil.getRegistryService();
        RealmService realmService = SAMLSSOUtil.getRealmService();
        if (domainName != null) {
            try {
                tenantID = realmService.getTenantManager().getTenantId(domainName);
            }
            catch (UserStoreException e) {
                String errorMsg = "Error getting the TenantID for the domain name";
                log.error((Object)errorMsg, (Throwable)e);
                throw new IdentitySAML2SSOException(errorMsg, e);
            }
        }
        KeyStoreManager keyStoreManager = KeyStoreManager.getInstance((int)tenantID);
        X509CredentialImpl credentialImpl = null;
        try {
            KeyStore keyStore = tenantID != 0 ? keyStoreManager.getKeyStore(SAMLSSOUtil.generateKSNameFromDomainName(domainName)) : keyStoreManager.getPrimaryKeyStore();
            java.security.cert.X509Certificate cert = (java.security.cert.X509Certificate)keyStore.getCertificate(alias);
            credentialImpl = new X509CredentialImpl(cert);
        }
        catch (Exception e) {
            String errorMsg = "Error instantiating an X509CredentialImpl object for the public cert.";
            log.error((Object)errorMsg, (Throwable)e);
            throw new IdentitySAML2SSOException(errorMsg, e);
        }
        return credentialImpl;
    }

    public static boolean validateAssertionSignature(String assertion, String alias, String domainName) {
        boolean isSignatureValid = false;
        try {
            RequestAbstractType request = (RequestAbstractType)SAMLSSOUtil.unmarshall(SAMLSSOUtil.decode(assertion));
            isSignatureValid = SAMLSSOUtil.validateAssertionSignature(request, alias, domainName);
        }
        catch (IdentityException ignore) {
            log.warn((Object)"Signature Validation failed for the SAML Assertion : Failed to unmarshall the SAML Assertion");
        }
        return isSignatureValid;
    }

    public static boolean validateAssertionSignature(RequestAbstractType assertion, String alias, String domainName) {
        boolean isSignatureValid = false;
        if (assertion.getSignature() != null) {
            try {
                SignatureValidator validator = new SignatureValidator((Credential)SAMLSSOUtil.getX509CredentialImplForTenant(domainName, alias));
                validator.validate(assertion.getSignature());
                isSignatureValid = true;
            }
            catch (IdentitySAML2SSOException ignore) {
                log.warn((Object)("Signature validation failed for the SAML Assertion : Failed to construct the X509CredentialImpl for the alias " + alias));
            }
            catch (ValidationException ignore) {
                log.warn((Object)"Signature Validation Failed for the SAML Assertion : Signature is invalid.");
            }
        }
        return isSignatureValid;
    }

    static {
        isBootStrapped = false;
        random = new Random();
        charMapping = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p'};
    }
}

