/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.saml.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.identity.sso.saml.SSOServiceProviderConfigManager;
import org.wso2.carbon.identity.sso.saml.util.SAMLSSOUtil;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.ConfigurationContextService;

public class IdentitySAMLSSOServiceComponent {
    private static Log log = LogFactory.getLog(IdentitySAMLSSOServiceComponent.class);

    protected void activate(ComponentContext ctxt) {
        SAMLSSOUtil.setBundleContext(ctxt.getBundleContext());
        ctxt.getBundleContext().registerService(SSOServiceProviderConfigManager.class.getName(), (Object)SSOServiceProviderConfigManager.getInstance(), null);
        if (log.isDebugEnabled()) {
            log.info((Object)"Identity SAML SSO bundle is activated");
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        SAMLSSOUtil.setBundleContext(null);
        if (log.isDebugEnabled()) {
            log.info((Object)"Identity SAML SSO bundle is deactivated");
        }
    }

    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService set in Identity SAML SSO bundle");
        }
        try {
            SAMLSSOUtil.setRegistryService(registryService);
        }
        catch (Throwable e) {
            log.error((Object)"Failed to get a reference to the Registry in SAML SSO bundle", e);
        }
    }

    protected void unsetRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unset in SAML SSO bundle");
        }
        SAMLSSOUtil.setRegistryService(null);
    }

    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Realm Service is set in the SAML SSO bundle");
        }
        SAMLSSOUtil.setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Realm Service is set in the SAML SSO bundle");
        }
        SAMLSSOUtil.setRegistryService(null);
    }

    protected void setConfigurationContextService(ConfigurationContextService configCtxService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Configuration Context Service is set in the SAML SSO bundle");
        }
        SAMLSSOUtil.setConfigCtxService(configCtxService);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configCtxService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Configuration Context Service is unset in the SAML SSO bundle");
        }
        SAMLSSOUtil.setConfigCtxService(null);
    }
}

