/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.saml.builders;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import javax.crypto.SecretKey;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.CredentialContextSet;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.x509.X509Credential;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.sso.saml.util.SAMLSSOUtil;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.security.keystore.KeyStoreAdmin;
import org.wso2.carbon.utils.AuthenticationObserver;
import org.wso2.carbon.utils.TenantUtils;

public class SignKeyDataHolder
implements X509Credential {
    private String signatureAlgorithm = null;
    private static SignKeyDataHolder instance = null;
    private X509Certificate[] issuerCerts = null;
    private PrivateKey issuerPK = null;

    private void initializeRegistry(int tenantId) {
        BundleContext bundleContext = SAMLSSOUtil.getBundleContext();
        if (bundleContext != null) {
            ServiceTracker tracker = new ServiceTracker(bundleContext, AuthenticationObserver.class.getName(), null);
            tracker.open();
            Object[] services = tracker.getServices();
            if (services != null) {
                for (Object service : services) {
                    ((AuthenticationObserver)service).startedAuthentication(tenantId);
                }
            }
            tracker.close();
        }
    }

    public SignKeyDataHolder(String username) throws IdentityException {
        String keyAlias = null;
        try {
            String tenantDomain = TenantUtils.getTenantDomain((String)username);
            int tenantID = SAMLSSOUtil.getRealmService().getTenantManager().getTenantId(tenantDomain);
            this.initializeRegistry(tenantID);
            if (tenantID != -1234) {
                String keyStoreName = SAMLSSOUtil.generateKSNameFromDomainName(tenantDomain);
                keyAlias = tenantDomain;
                KeyStoreManager keyMan = KeyStoreManager.getInstance((int)tenantID);
                KeyStore keyStore = keyMan.getKeyStore(keyStoreName);
                this.issuerPK = (PrivateKey)keyMan.getPrivateKey(keyStoreName, tenantDomain);
                Certificate[] certificates = keyStore.getCertificateChain(keyAlias);
                this.issuerCerts = new X509Certificate[certificates.length];
                int i = 0;
                for (Certificate certificate : certificates) {
                    this.issuerCerts[i++] = (X509Certificate)certificate;
                }
                this.signatureAlgorithm = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
                String pubKeyAlgo = this.issuerCerts[0].getPublicKey().getAlgorithm();
                if (pubKeyAlgo.equalsIgnoreCase("DSA")) {
                    this.signatureAlgorithm = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
                }
            } else {
                keyAlias = ServerConfiguration.getInstance().getFirstProperty("Security.KeyStore.KeyAlias");
                KeyStoreAdmin keyAdmin = new KeyStoreAdmin(tenantID, (Registry)SAMLSSOUtil.getRegistryService().getGovernanceSystemRegistry());
                KeyStoreManager keyMan = KeyStoreManager.getInstance((int)tenantID);
                this.issuerPK = (PrivateKey)keyAdmin.getPrivateKey(keyAlias, true);
                Certificate[] certificates = keyMan.getPrimaryKeyStore().getCertificateChain(keyAlias);
                this.issuerCerts = new X509Certificate[certificates.length];
                int i = 0;
                for (Certificate certificate : certificates) {
                    this.issuerCerts[i++] = (X509Certificate)certificate;
                }
                this.signatureAlgorithm = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
                String pubKeyAlgo = this.issuerCerts[0].getPublicKey().getAlgorithm();
                if (pubKeyAlgo.equalsIgnoreCase("DSA")) {
                    this.signatureAlgorithm = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
                }
            }
        }
        catch (Exception e) {
            throw new IdentityException(e.getMessage(), (Throwable)e);
        }
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public Collection<X509CRL> getCRLs() {
        return null;
    }

    public X509Certificate getEntityCertificate() {
        return this.issuerCerts[0];
    }

    public Collection<X509Certificate> getEntityCertificateChain() {
        return Arrays.asList(this.issuerCerts);
    }

    public CredentialContextSet getCredentalContextSet() {
        return null;
    }

    public Class<? extends Credential> getCredentialType() {
        return null;
    }

    public String getEntityId() {
        return null;
    }

    public Collection<String> getKeyNames() {
        return null;
    }

    public PrivateKey getPrivateKey() {
        return this.issuerPK;
    }

    public PublicKey getPublicKey() {
        return this.issuerCerts[0].getPublicKey();
    }

    public SecretKey getSecretKey() {
        return null;
    }

    public UsageType getUsageType() {
        return null;
    }
}

