/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.saml;

import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.model.SAMLSSOServiceProviderDO;

public class SSOServiceProviderConfigManager {
    private static Log log = LogFactory.getLog(SSOServiceProviderConfigManager.class);
    private static SSOServiceProviderConfigManager instance;
    private ConcurrentHashMap<String, SAMLSSOServiceProviderDO> serviceProviderMap = new ConcurrentHashMap();

    private SSOServiceProviderConfigManager() {
    }

    public static SSOServiceProviderConfigManager getInstance() {
        if (instance == null) {
            instance = new SSOServiceProviderConfigManager();
        }
        return instance;
    }

    public void addServiceProvider(String issuerName, SAMLSSOServiceProviderDO spDO) {
        if (this.serviceProviderMap.containsKey(issuerName)) {
            log.warn((Object)"Duplicate Service Providers detected.");
            return;
        }
        this.serviceProviderMap.put(issuerName, spDO);
        if (log.isDebugEnabled()) {
            log.debug((Object)("A Service Provider is added to the Service Provider Map with the issuer name : " + issuerName));
        }
    }

    public SAMLSSOServiceProviderDO getServiceProvider(String issuerName) {
        return this.serviceProviderMap.get(issuerName);
    }

    public Enumeration<SAMLSSOServiceProviderDO> getAllServiceProviders() {
        return this.serviceProviderMap.elements();
    }
}

