/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.saml;

import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.LogoutRequest;
import org.opensaml.xml.XMLObject;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.sso.saml.dto.SAMLSSOAuthnReqDTO;
import org.wso2.carbon.identity.sso.saml.dto.SAMLSSOReqValidationResponseDTO;
import org.wso2.carbon.identity.sso.saml.dto.SAMLSSORespDTO;
import org.wso2.carbon.identity.sso.saml.processors.AuthnRequestProcessor;
import org.wso2.carbon.identity.sso.saml.processors.LogoutRequestProcessor;
import org.wso2.carbon.identity.sso.saml.session.SSOSessionPersistenceManager;
import org.wso2.carbon.identity.sso.saml.util.SAMLSSOUtil;
import org.wso2.carbon.identity.sso.saml.validators.AuthnRequestValidator;

public class SAMLSSOService {
    public SAMLSSOReqValidationResponseDTO validateRequest(String authReq, String sessionId, String rpSessionId, String authnMode) throws IdentityException {
        XMLObject request = SAMLSSOUtil.unmarshall(SAMLSSOUtil.decode(authReq));
        if (request instanceof AuthnRequest) {
            AuthnRequestValidator authnRequestValidator = new AuthnRequestValidator((AuthnRequest)request);
            SAMLSSOReqValidationResponseDTO validationResp = authnRequestValidator.validate();
            validationResp.setAssertionString(authReq);
            if (validationResp.isValid()) {
                SSOSessionPersistenceManager sessionPersistenceManager = SSOSessionPersistenceManager.getPersistenceManager();
                boolean isExistingSession = sessionPersistenceManager.isExistingSession(sessionId);
                if (authnMode.equals("openIDBasedAuthn") && !isExistingSession) {
                    AuthnRequestProcessor authnRequestProcessor = new AuthnRequestProcessor();
                    try {
                        return authnRequestProcessor.process(validationResp, sessionId, rpSessionId, authnMode);
                    }
                    catch (Exception e) {
                        throw new IdentityException("Error processing the Authentication Request", (Throwable)e);
                    }
                }
                if (isExistingSession) {
                    AuthnRequestProcessor authnRequestProcessor = new AuthnRequestProcessor();
                    try {
                        return authnRequestProcessor.process(validationResp, sessionId, rpSessionId, authnMode);
                    }
                    catch (Exception e) {
                        throw new IdentityException("Error processing the Authentication Request", (Throwable)e);
                    }
                }
            }
            validationResp.setRpSessionId(rpSessionId);
            return validationResp;
        }
        if (request instanceof LogoutRequest) {
            LogoutRequestProcessor logoutReqProcessor = new LogoutRequestProcessor();
            SAMLSSOReqValidationResponseDTO validationResponseDTO = logoutReqProcessor.process((LogoutRequest)request, sessionId);
            return validationResponseDTO;
        }
        return null;
    }

    public SAMLSSORespDTO authenticate(SAMLSSOAuthnReqDTO authReqDTO, String sessionId) throws IdentityException {
        AuthnRequestProcessor authnRequestProcessor = new AuthnRequestProcessor();
        try {
            return authnRequestProcessor.process(authReqDTO, sessionId, false, "usernamePasswordBasedAuthn");
        }
        catch (Exception e) {
            throw new IdentityException("Error when authenticating the users", (Throwable)e);
        }
    }

    public SAMLSSOReqValidationResponseDTO doSingleLogout(String sessionId) throws IdentityException {
        LogoutRequestProcessor logoutReqProcessor = new LogoutRequestProcessor();
        SAMLSSOReqValidationResponseDTO validationResponseDTO = logoutReqProcessor.process(null, sessionId);
        return validationResponseDTO;
    }
}

