/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.saml;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.util.KeyStoreUtil;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.sso.saml.admin.SAMLSSOConfigAdmin;
import org.wso2.carbon.identity.sso.saml.dto.SAMLSSOServiceProviderDTO;
import org.wso2.carbon.identity.sso.saml.dto.SAMLSSOServiceProviderInfoDTO;
import org.wso2.carbon.identity.sso.saml.util.SAMLSSOUtil;
import org.wso2.carbon.security.SecurityConfigException;
import org.wso2.carbon.security.keystore.KeyStoreAdmin;
import org.wso2.carbon.security.keystore.service.KeyStoreData;

public class SAMLSSOConfigService
extends AbstractAdmin {
    private static Log log = LogFactory.getLog(SAMLSSOConfigService.class);

    public boolean addRPServiceProvider(SAMLSSOServiceProviderDTO spDto) throws IdentityException {
        SAMLSSOConfigAdmin configAdmin = new SAMLSSOConfigAdmin(this.getConfigSystemRegistry());
        return configAdmin.addRelyingPartyServiceProvider(spDto);
    }

    public SAMLSSOServiceProviderInfoDTO getServiceProviders() throws IdentityException {
        SAMLSSOConfigAdmin configAdmin = new SAMLSSOConfigAdmin(this.getConfigSystemRegistry());
        return configAdmin.getServiceProviders();
    }

    private KeyStoreData[] getKeyStores() throws IdentityException {
        try {
            KeyStoreAdmin admin = new KeyStoreAdmin(CarbonContext.getCurrentContext().getTenantId(), this.getGovernanceRegistry());
            boolean isSuperAdmin = super.getTenantDomain() == null;
            return admin.getKeyStores(isSuperAdmin);
        }
        catch (SecurityConfigException e) {
            log.error((Object)"Error when loading the key stores from registry", (Throwable)e);
            throw new IdentityException("Error when loading the key stores from registry", (Throwable)e);
        }
    }

    public String[] getCertAliasOfPrimaryKeyStore() throws IdentityException {
        KeyStoreData[] keyStores = this.getKeyStores();
        KeyStoreData primaryKeyStore = null;
        for (int i = 0; i < keyStores.length; ++i) {
            if (this.getTenantDomain() == null && KeyStoreUtil.isPrimaryStore((String)keyStores[i].getKeyStoreName())) {
                primaryKeyStore = keyStores[i];
                break;
            }
            if (this.getTenantDomain() == null || !SAMLSSOUtil.generateKSNameFromDomainName(this.getTenantDomain()).equals(keyStores[i].getKeyStoreName())) continue;
            primaryKeyStore = keyStores[i];
            break;
        }
        if (primaryKeyStore != null) {
            return this.getStoreEntries(primaryKeyStore.getKeyStoreName());
        }
        throw new IdentityException("Primary Keystore cannot be found.");
    }

    public boolean removeServiceProvider(String issuer) throws IdentityException {
        SAMLSSOConfigAdmin ssoConfigAdmin = new SAMLSSOConfigAdmin(this.getConfigSystemRegistry());
        return ssoConfigAdmin.removeServiceProvider(issuer);
    }

    private String[] getStoreEntries(String keyStoreName) throws IdentityException {
        try {
            KeyStoreAdmin admin = new KeyStoreAdmin(CarbonContext.getCurrentContext().getTenantId(), this.getGovernanceRegistry());
            return admin.getStoreEntries(keyStoreName);
        }
        catch (SecurityConfigException e) {
            log.error((Object)("Error reading entries from the key store : " + keyStoreName));
            throw new IdentityException("Error reading entries from the keystore" + (Object)((Object)e));
        }
    }
}

