/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.saml.session;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.wso2.carbon.identity.core.model.SAMLSSOServiceProviderDO;

public class SessionInfoData {
    private String subject;
    private Map<String, String> rpSessionList = new ConcurrentHashMap<String, String>();
    private Map<String, SAMLSSOServiceProviderDO> serviceProviderList = new ConcurrentHashMap<String, SAMLSSOServiceProviderDO>();

    public SessionInfoData(String subject) {
        this.subject = subject;
    }

    public String getSubject() {
        return this.subject;
    }

    public Map<String, SAMLSSOServiceProviderDO> getServiceProviderList() {
        return this.serviceProviderList;
    }

    public void addServiceProvider(String issuer, SAMLSSOServiceProviderDO spDO, String rpSessionId) {
        this.serviceProviderList.put(issuer, spDO);
        if (rpSessionId != null) {
            this.rpSessionList.put(issuer, rpSessionId);
        }
    }

    public void removeServiceProvider(String issuer) {
        this.serviceProviderList.remove(issuer);
        this.rpSessionList.remove(issuer);
    }

    public Map<String, String> getRPSessionsList() {
        return this.rpSessionList;
    }
}

