/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.saml.session;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.state.Replicator;
import org.apache.axis2.clustering.state.StateClusteringCommand;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.util.AnonymousSessionUtil;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.model.SAMLSSOServiceProviderDO;
import org.wso2.carbon.identity.core.persistence.IdentityPersistenceManager;
import org.wso2.carbon.identity.sso.saml.SSOServiceProviderConfigManager;
import org.wso2.carbon.identity.sso.saml.session.SSOSessionCommand;
import org.wso2.carbon.identity.sso.saml.session.SessionInfoData;
import org.wso2.carbon.identity.sso.saml.util.SAMLSSOUtil;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;

public class SSOSessionPersistenceManager {
    private static Log log = LogFactory.getLog(SSOSessionPersistenceManager.class);
    private static SSOSessionPersistenceManager sessionPersistenceManager;
    private Map<String, SessionInfoData> sessionMap = new ConcurrentHashMap<String, SessionInfoData>();

    public static SSOSessionPersistenceManager getPersistenceManager() {
        if (sessionPersistenceManager == null) {
            sessionPersistenceManager = new SSOSessionPersistenceManager();
        }
        return sessionPersistenceManager;
    }

    public Map<String, SessionInfoData> getSessionMap() {
        return this.sessionMap;
    }

    public void persistSession(String sessionId, String subject, SAMLSSOServiceProviderDO spDO, String rpSessionId) throws IdentityException {
        if (!this.sessionMap.containsKey(sessionId)) {
            SessionInfoData sessionInfoData = new SessionInfoData(subject);
            sessionInfoData.addServiceProvider(spDO.getIssuer(), spDO, rpSessionId);
            this.sessionMap.put(sessionId, sessionInfoData);
            this.replicateSessionInfo(sessionId, subject, spDO, rpSessionId);
        } else {
            this.persistSession(sessionId, spDO.getIssuer(), spDO.getAssertionConsumerUrl(), rpSessionId);
        }
    }

    public boolean persistSession(String sessionId, String issuer, String assertionConsumerURL, String rpSessionId) throws IdentityException {
        try {
            if (sessionId != null) {
                if (this.sessionMap.containsKey(sessionId)) {
                    SessionInfoData sessionInfoData = this.sessionMap.get(sessionId);
                    String subject = sessionInfoData.getSubject();
                    SAMLSSOServiceProviderDO spDO = SSOServiceProviderConfigManager.getInstance().getServiceProvider(issuer);
                    if (spDO == null) {
                        IdentityPersistenceManager identityPersistenceManager = IdentityPersistenceManager.getPersistanceManager();
                        spDO = identityPersistenceManager.getServiceProvider((Registry)AnonymousSessionUtil.getSystemRegistryByUserName((RegistryService)SAMLSSOUtil.getRegistryService(), (RealmService)SAMLSSOUtil.getRealmService(), (String)subject), issuer);
                    }
                    if (assertionConsumerURL != null) {
                        spDO.setAssertionConsumerUrl(assertionConsumerURL);
                    }
                    sessionInfoData.addServiceProvider(spDO.getIssuer(), spDO, rpSessionId);
                    this.replicateSessionInfo(sessionId, subject, spDO, rpSessionId);
                    return true;
                }
                log.error((Object)"Error persisting the new session, there is no previously established session for this user");
                return false;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error obtaining the service provider info from registry", (Throwable)e);
            throw new IdentityException("Error obtaining the service provider info from registry", (Throwable)e);
        }
        return false;
    }

    public SessionInfoData getSessionInfo(String sessionId) {
        if (sessionId != null) {
            return this.sessionMap.get(sessionId);
        }
        return null;
    }

    public void removeSession(String sessionId, String issuer) {
        if (sessionId != null) {
            this.sessionMap.remove(sessionId);
        }
    }

    public boolean isExistingSession(String sessionId) {
        return this.sessionMap.containsKey(sessionId);
    }

    private void replicateSessionInfo(String sessionId, String subject, SAMLSSOServiceProviderDO spDO, String rpSessionId) {
        SSOSessionCommand sessionCommand = new SSOSessionCommand();
        sessionCommand.setUsername(subject);
        sessionCommand.setAssertionConsumerURL(spDO.getAssertionConsumerUrl());
        sessionCommand.setIssuer(spDO.getIssuer());
        sessionCommand.setRpSessionID(rpSessionId);
        sessionCommand.setSsoTokenID(sessionId);
        sessionCommand.setSignOut(false);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Starting to replicate Session Info for TokenID : " + sessionId));
            }
            Replicator.replicateState((StateClusteringCommand)sessionCommand, (AxisConfiguration)SAMLSSOUtil.getConfigCtxService().getServerConfigContext().getAxisConfiguration());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Completed replicating Session Info for TokenID : " + sessionId));
            }
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Error when replicating the session info within the cluster", (Throwable)axisFault);
        }
    }
}

