/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.saml.session;

import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.state.StateClusteringCommand;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.model.SAMLSSOServiceProviderDO;
import org.wso2.carbon.identity.sso.saml.session.SSOSessionPersistenceManager;
import org.wso2.carbon.identity.sso.saml.session.SessionInfoData;

public class SSOSessionCommand
extends StateClusteringCommand {
    private static Log log = LogFactory.getLog(SSOSessionCommand.class);
    private boolean isSignOut;
    private String ssoTokenID;
    private String username;
    private String issuer;
    private String rpSessionID;
    private String assertionConsumerURL;

    public void execute(ConfigurationContext configurationContext) throws ClusteringFault {
        SSOSessionPersistenceManager ssoPersistManager = SSOSessionPersistenceManager.getPersistenceManager();
        if (this.isSignOut) {
            if (log.isDebugEnabled()) {
                log.info((Object)("Starting session replication for sign out request with TokenID : " + this.ssoTokenID));
            }
            if (ssoPersistManager.isExistingSession(this.ssoTokenID)) {
                ssoPersistManager.removeSession(this.ssoTokenID, this.issuer);
            }
        } else {
            SAMLSSOServiceProviderDO spDO = new SAMLSSOServiceProviderDO();
            spDO.setIssuer(this.issuer);
            spDO.setAssertionConsumerUrl(this.assertionConsumerURL);
            if (ssoPersistManager.isExistingSession(this.ssoTokenID)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Added a new Service Provider entry for : " + this.issuer + " during the session replication for the TokenID : " + this.ssoTokenID));
                }
                SessionInfoData sessionInfoData = ssoPersistManager.getSessionInfo(this.ssoTokenID);
                sessionInfoData.addServiceProvider(this.issuer, spDO, this.rpSessionID);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Added a new Session Info with a Service Provider entry for : " + this.issuer + " during the session replication for the TokenID : " + this.ssoTokenID));
                }
                SessionInfoData sessionInfoData = new SessionInfoData(this.username);
                sessionInfoData.addServiceProvider(spDO.getIssuer(), spDO, this.rpSessionID);
                ssoPersistManager.getSessionMap().put(this.ssoTokenID, sessionInfoData);
            }
        }
    }

    public void setSsoTokenID(String ssoTokenID) {
        this.ssoTokenID = ssoTokenID;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public void setRpSessionID(String rpSessionID) {
        this.rpSessionID = rpSessionID;
    }

    public void setAssertionConsumerURL(String assertionConsumerURL) {
        this.assertionConsumerURL = assertionConsumerURL;
    }

    public void setSignOut(boolean signOut) {
        this.isSignOut = signOut;
    }
}

