/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.saml.processors;

import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.state.Replicator;
import org.apache.axis2.clustering.state.StateClusteringCommand;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.saml2.core.LogoutRequest;
import org.opensaml.saml2.core.LogoutResponse;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.RequestAbstractType;
import org.opensaml.xml.XMLObject;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.model.SAMLSSOServiceProviderDO;
import org.wso2.carbon.identity.sso.saml.builders.SingleLogoutMessageBuilder;
import org.wso2.carbon.identity.sso.saml.dto.SAMLSSOReqValidationResponseDTO;
import org.wso2.carbon.identity.sso.saml.dto.SingleLogoutRequestDTO;
import org.wso2.carbon.identity.sso.saml.session.SSOSessionCommand;
import org.wso2.carbon.identity.sso.saml.session.SSOSessionPersistenceManager;
import org.wso2.carbon.identity.sso.saml.session.SessionInfoData;
import org.wso2.carbon.identity.sso.saml.util.SAMLSSOUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class LogoutRequestProcessor {
    private static Log log = LogFactory.getLog(LogoutRequestProcessor.class);

    public SAMLSSOReqValidationResponseDTO process(LogoutRequest logoutRequest, String sessionId) throws IdentityException {
        try {
            boolean isSignatureValid;
            SSOSessionPersistenceManager ssoSessionPersistenceManager;
            SessionInfoData sessionInfoData;
            SAMLSSOReqValidationResponseDTO reqValidationResponseDTO = new SAMLSSOReqValidationResponseDTO();
            reqValidationResponseDTO.setLogOutReq(true);
            String subject = null;
            if (logoutRequest != null) {
                if (logoutRequest.getIssuer() == null) {
                    String message = "Issuer should be mentioned in the Logout Request";
                    log.error((Object)message);
                    return this.buildErrorResponse(logoutRequest.getID(), "urn:oasis:names:tc:SAML:2.0:status:Requester", message);
                }
                if (logoutRequest.getNameID() == null) {
                    String message = "Subject Name should be specified in the Logout Request";
                    log.error((Object)message);
                    return this.buildErrorResponse(logoutRequest.getID(), "urn:oasis:names:tc:SAML:2.0:status:Requester", message);
                }
                NameID nameID = logoutRequest.getNameID();
                subject = nameID.getValue();
                if (logoutRequest.getSessionIndexes() == null) {
                    String message = "At least one Session Index should be present in the Logout Request";
                    log.error((Object)message);
                    return this.buildErrorResponse(logoutRequest.getID(), "urn:oasis:names:tc:SAML:2.0:status:Requester", message);
                }
            }
            if ((sessionInfoData = (ssoSessionPersistenceManager = SSOSessionPersistenceManager.getPersistenceManager()).getSessionInfo(sessionId)) == null) {
                String message = "No Established Sessions corresponding to Session Indexes provided.";
                log.error((Object)message);
                return this.buildErrorResponse(logoutRequest.getID(), "urn:oasis:names:tc:SAML:2.0:status:Requester", message);
            }
            subject = sessionInfoData.getSubject();
            String issuer = logoutRequest.getIssuer().getValue();
            Map<String, SAMLSSOServiceProviderDO> sessionsList = sessionInfoData.getServiceProviderList();
            SAMLSSOServiceProviderDO logoutReqIssuer = sessionsList.get(issuer);
            if (logoutReqIssuer.getCertAlias() != null && !(isSignatureValid = SAMLSSOUtil.validateAssertionSignature((RequestAbstractType)logoutRequest, logoutReqIssuer.getCertAlias(), MultitenantUtils.getTenantDomain((String)subject)))) {
                String message = "The signature contained in the Assertion is not valid.";
                log.error((Object)message);
                return this.buildErrorResponse(logoutRequest.getID(), "urn:oasis:names:tc:SAML:2.0:status:Requester", message);
            }
            SingleLogoutMessageBuilder logoutMsgBuilder = new SingleLogoutMessageBuilder();
            Map<String, String> rpSessionsList = sessionInfoData.getRPSessionsList();
            SingleLogoutRequestDTO[] singleLogoutReqDTOs = new SingleLogoutRequestDTO[sessionsList.size() - 1];
            LogoutRequest logoutReq = logoutMsgBuilder.buildLogoutRequest(subject, sessionId, "urn:oasis:names:tc:SAML:2.0:logout:user");
            String logoutReqString = SAMLSSOUtil.encode(SAMLSSOUtil.marshall((XMLObject)logoutReq));
            int index = 0;
            for (String key : sessionsList.keySet()) {
                if (!key.equals(issuer)) {
                    SingleLogoutRequestDTO logoutReqDTO = new SingleLogoutRequestDTO();
                    logoutReqDTO.setAssertionConsumerURL(sessionsList.get(key).getLogoutURL());
                    if (sessionsList.get(key).getLogoutURL() == null || sessionsList.get(key).getLogoutURL().length() == 0) {
                        logoutReqDTO.setAssertionConsumerURL(sessionsList.get(key).getAssertionConsumerUrl());
                    }
                    logoutReqDTO.setLogoutResponse(logoutReqString);
                    logoutReqDTO.setRpSessionId(rpSessionsList.get(key));
                    singleLogoutReqDTOs[index] = logoutReqDTO;
                    ++index;
                    continue;
                }
                reqValidationResponseDTO.setIssuer(sessionsList.get(key).getIssuer());
                reqValidationResponseDTO.setAssertionConsumerURL(sessionsList.get(key).getAssertionConsumerUrl());
                if (sessionsList.get(key).getLogoutURL() == null || sessionsList.get(key).getLogoutURL().length() <= 0) continue;
                reqValidationResponseDTO.setAssertionConsumerURL(sessionsList.get(key).getLogoutURL());
            }
            reqValidationResponseDTO.setLogoutRespDTO(singleLogoutReqDTOs);
            if (logoutRequest != null) {
                LogoutResponse logoutResponse = logoutMsgBuilder.buildLogoutResponse(logoutRequest.getID(), "urn:oasis:names:tc:SAML:2.0:status:Success", null);
                reqValidationResponseDTO.setLogoutResponse(SAMLSSOUtil.encode(SAMLSSOUtil.marshall((XMLObject)logoutResponse)));
                reqValidationResponseDTO.setValid(true);
            }
            ssoSessionPersistenceManager.removeSession(sessionId, issuer);
            this.replicateSessionInfo(sessionId, issuer);
            return reqValidationResponseDTO;
        }
        catch (Exception e) {
            log.error((Object)"Error Processing the Logout Request", (Throwable)e);
            throw new IdentityException("Error Processing the Logout Request", (Throwable)e);
        }
    }

    private SAMLSSOReqValidationResponseDTO buildErrorResponse(String id, String status, String statMsg) throws Exception {
        SAMLSSOReqValidationResponseDTO reqValidationResponseDTO = new SAMLSSOReqValidationResponseDTO();
        LogoutResponse logoutResp = new SingleLogoutMessageBuilder().buildLogoutResponse(id, status, statMsg);
        reqValidationResponseDTO.setLogOutReq(true);
        reqValidationResponseDTO.setValid(false);
        reqValidationResponseDTO.setResponse(SAMLSSOUtil.encode(SAMLSSOUtil.marshall((XMLObject)logoutResp)));
        return reqValidationResponseDTO;
    }

    private void replicateSessionInfo(String sessionID, String issuer) {
        SSOSessionCommand sessionCommand = new SSOSessionCommand();
        sessionCommand.setSsoTokenID(sessionID);
        sessionCommand.setIssuer(issuer);
        sessionCommand.setSignOut(true);
        try {
            if (log.isDebugEnabled()) {
                log.info((Object)("Starting to replicate sign-out session Info for TokenID : " + sessionID));
            }
            Replicator.replicateState((StateClusteringCommand)sessionCommand, (AxisConfiguration)SAMLSSOUtil.getConfigCtxService().getServerConfigContext().getAxisConfiguration());
            if (log.isDebugEnabled()) {
                log.info((Object)("Completed replicating sign-out Session Info for TokenID : " + sessionID));
            }
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Error when replicating the sign-out session info within the cluster", (Throwable)axisFault);
        }
    }
}

