/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.saml.processors;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.saml2.core.Response;
import org.opensaml.xml.XMLObject;
import org.wso2.carbon.core.util.AnonymousSessionUtil;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.model.SAMLSSOServiceProviderDO;
import org.wso2.carbon.identity.core.persistence.IdentityPersistenceManager;
import org.wso2.carbon.identity.sso.saml.SSOServiceProviderConfigManager;
import org.wso2.carbon.identity.sso.saml.builders.ErrorResponseBuilder;
import org.wso2.carbon.identity.sso.saml.builders.ResponseBuilder;
import org.wso2.carbon.identity.sso.saml.dto.SAMLSSOAuthnReqDTO;
import org.wso2.carbon.identity.sso.saml.dto.SAMLSSOReqValidationResponseDTO;
import org.wso2.carbon.identity.sso.saml.dto.SAMLSSORespDTO;
import org.wso2.carbon.identity.sso.saml.session.SSOSessionPersistenceManager;
import org.wso2.carbon.identity.sso.saml.session.SessionInfoData;
import org.wso2.carbon.identity.sso.saml.util.SAMLSSOUtil;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class AuthnRequestProcessor {
    private static Log log = LogFactory.getLog(AuthnRequestProcessor.class);

    public SAMLSSORespDTO process(SAMLSSOAuthnReqDTO authnReqDTO, String sessionId, boolean isAuthencated, String authMode) throws Exception {
        try {
            boolean isSignatureValid;
            if (!this.validateIssuer(authnReqDTO)) {
                String msg = "Issuer details are not valid. Issuer details should be registered in advance";
                log.warn((Object)msg);
                return this.buildErrorResponse(authnReqDTO.getId(), "urn:oasis:names:tc:SAML:2.0:status:Requester", msg);
            }
            if (authnReqDTO.getCertAlias() != null && !(isSignatureValid = SAMLSSOUtil.validateAssertionSignature(authnReqDTO.getAssertionString(), authnReqDTO.getCertAlias(), MultitenantUtils.getTenantDomain((String)authnReqDTO.getUsername())))) {
                String msg = "Signature Validation Failed for the SAML Assertion.";
                log.warn((Object)msg);
                return this.buildErrorResponse(authnReqDTO.getId(), "urn:oasis:names:tc:SAML:2.0:status:Requester", msg);
            }
            if (authnReqDTO.getSubject() != null && authnReqDTO.getUsername() != null && !authnReqDTO.getUsername().equals(authnReqDTO.getSubject())) {
                String msg = "Provided username does not match with the requested subject";
                log.warn((Object)msg);
                return this.buildErrorResponse(authnReqDTO.getId(), "urn:oasis:names:tc:SAML:2.0:status:AuthnFailed", msg);
            }
            SSOSessionPersistenceManager sessionPersistenceManager = SSOSessionPersistenceManager.getPersistenceManager();
            if (!isAuthencated && authMode.equals("usernamePasswordBasedAuthn")) {
                boolean isTenantActive;
                String tenantDomain;
                RealmService realmService = SAMLSSOUtil.getRealmService();
                TenantManager tenantManager = realmService.getTenantManager();
                int tenantId = tenantManager.getTenantId(tenantDomain = MultitenantUtils.getTenantDomain((String)authnReqDTO.getUsername()));
                if (tenantId > 0 && !(isTenantActive = tenantManager.isTenantActive(tenantId))) {
                    log.warn((Object)("Unsuccessful login attempt from the tenant : " + tenantDomain));
                    String errorMsg = "login.fail.inactive.tenant";
                    SAMLSSORespDTO errorResp = this.buildErrorResponse(authnReqDTO.getId(), "urn:oasis:names:tc:SAML:2.0:status:AuthnFailed", errorMsg);
                    errorResp.setErrorMsg(errorMsg);
                    errorResp.setLoginPageURL(authnReqDTO.getLoginPageURL());
                    return errorResp;
                }
                if (!this.authenticate(authnReqDTO.getUsername(), authnReqDTO.getPassword())) {
                    log.warn((Object)"Authentication Failure, invalid username or password.");
                    String errorMsg = "login.fail.message";
                    SAMLSSORespDTO errorResp = this.buildErrorResponse(authnReqDTO.getId(), "urn:oasis:names:tc:SAML:2.0:status:AuthnFailed", errorMsg);
                    errorResp.setErrorMsg(errorMsg);
                    errorResp.setLoginPageURL(authnReqDTO.getLoginPageURL());
                    return errorResp;
                }
                SAMLSSOServiceProviderDO spDO = new SAMLSSOServiceProviderDO();
                spDO.setIssuer(authnReqDTO.getIssuer());
                spDO.setAssertionConsumerUrl(authnReqDTO.getAssertionConsumerURL());
                spDO.setCertAlias(authnReqDTO.getCertAlias());
                spDO.setLogoutURL(authnReqDTO.getLogoutURL());
                sessionPersistenceManager.persistSession(sessionId, authnReqDTO.getUsername(), spDO, authnReqDTO.getRpSessionId());
            }
            if (isAuthencated && authMode.equals("usernamePasswordBasedAuthn")) {
                SessionInfoData sessionInfo = sessionPersistenceManager.getSessionInfo(sessionId);
                authnReqDTO.setUsername(sessionInfo.getSubject());
                sessionPersistenceManager.persistSession(sessionId, authnReqDTO.getIssuer(), authnReqDTO.getAssertionConsumerURL(), authnReqDTO.getRpSessionId());
            }
            if (isAuthencated && authMode.equals("openIDBasedAuthn")) {
                SAMLSSOServiceProviderDO spDO = new SAMLSSOServiceProviderDO();
                spDO.setIssuer(authnReqDTO.getIssuer());
                spDO.setAssertionConsumerUrl(authnReqDTO.getAssertionConsumerURL());
                spDO.setCertAlias(authnReqDTO.getCertAlias());
                spDO.setLogoutURL(authnReqDTO.getLogoutURL());
                sessionPersistenceManager.persistSession(sessionId, authnReqDTO.getUsername(), spDO, authnReqDTO.getRpSessionId());
            }
            ResponseBuilder respBuilder = new ResponseBuilder();
            Response response = respBuilder.buildResponse(authnReqDTO, sessionId);
            SAMLSSORespDTO samlssoRespDTO = new SAMLSSORespDTO();
            samlssoRespDTO.setRespString(SAMLSSOUtil.encode(SAMLSSOUtil.marshall((XMLObject)response)));
            samlssoRespDTO.setSessionEstablished(true);
            samlssoRespDTO.setAssertionConsumerURL(authnReqDTO.getAssertionConsumerURL());
            samlssoRespDTO.setLoginPageURL(authnReqDTO.getLoginPageURL());
            return samlssoRespDTO;
        }
        catch (Exception e) {
            log.error((Object)"Error processing the authentication request", (Throwable)e);
            SAMLSSORespDTO errorResp = this.buildErrorResponse(authnReqDTO.getId(), "urn:oasis:names:tc:SAML:2.0:status:AuthnFailed", "Authentication Failure, invalid username or password.");
            errorResp.setLoginPageURL(authnReqDTO.getLoginPageURL());
            return errorResp;
        }
    }

    public SAMLSSOReqValidationResponseDTO process(SAMLSSOReqValidationResponseDTO valiationDTO, String sessionId, String rpSessionId, String authMode) throws Exception {
        SAMLSSOAuthnReqDTO authReqDTO = new SAMLSSOAuthnReqDTO();
        authReqDTO.setIssuer(valiationDTO.getIssuer());
        authReqDTO.setAssertionConsumerURL(valiationDTO.getAssertionConsumerURL());
        authReqDTO.setSubject(valiationDTO.getSubject());
        authReqDTO.setId(valiationDTO.getId());
        authReqDTO.setRpSessionId(rpSessionId);
        authReqDTO.setAssertionString(valiationDTO.getAssertionString());
        if (authMode.equals("usernamePasswordBasedAuthn")) {
            SSOSessionPersistenceManager sessionPersistenceManager = SSOSessionPersistenceManager.getPersistenceManager();
            SessionInfoData sessionInfo = sessionPersistenceManager.getSessionInfo(sessionId);
            authReqDTO.setUsername(sessionInfo.getSubject());
        } else {
            authReqDTO.setUsername(valiationDTO.getSubject());
        }
        SAMLSSOReqValidationResponseDTO responseDTO = new SAMLSSOReqValidationResponseDTO();
        SAMLSSORespDTO respDTO = this.process(authReqDTO, sessionId, true, authMode);
        responseDTO.setValid(true);
        responseDTO.setResponse(respDTO.getRespString());
        responseDTO.setAssertionConsumerURL(respDTO.getAssertionConsumerURL());
        responseDTO.setLoginPageURL(respDTO.getLoginPageURL());
        return responseDTO;
    }

    private SAMLSSORespDTO buildErrorResponse(String id, String status, String statMsg) throws Exception {
        SAMLSSORespDTO samlSSORespDTO = new SAMLSSORespDTO();
        ErrorResponseBuilder errRespBuilder = new ErrorResponseBuilder();
        Response resp = errRespBuilder.buildResponse(id, status, statMsg);
        samlSSORespDTO.setRespString(SAMLSSOUtil.encode(SAMLSSOUtil.marshall((XMLObject)resp)));
        samlSSORespDTO.setSessionEstablished(false);
        return samlSSORespDTO;
    }

    private boolean authenticate(String username, String password) throws IdentityException {
        boolean isAuthenticated = false;
        try {
            UserRealm realm = AnonymousSessionUtil.getRealmByUserName((RegistryService)SAMLSSOUtil.getRegistryService(), (RealmService)SAMLSSOUtil.getRealmService(), (String)username);
            if (realm == null) {
                log.warn((Object)"Realm creation failed. Tenant may be inactive or invalid.");
                return false;
            }
            UserStoreManager userStoreManager = realm.getUserStoreManager();
            isAuthenticated = userStoreManager.authenticate(MultitenantUtils.getTenantAwareUsername((String)username), (Object)password);
            if (!isAuthenticated) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"user authentication failed due to invalid credentials.");
                }
                return false;
            }
            boolean isAuthorized = realm.getAuthorizationManager().isUserAuthorized(MultitenantUtils.getTenantAwareUsername((String)username), "/permission/admin/login", "ui.execute");
            if (!isAuthorized) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Authorization Failure when performing log-in action");
                }
                return false;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"User is successfully authenticated.");
            }
            return true;
        }
        catch (Exception e) {
            String msg = "Error obtaining user realm for authenticating the user";
            log.error((Object)msg, (Throwable)e);
            throw new IdentityException(msg, (Throwable)e);
        }
    }

    private boolean validateIssuer(SAMLSSOAuthnReqDTO authReqDTO) throws IdentityException {
        try {
            SSOServiceProviderConfigManager spConfigManager = SSOServiceProviderConfigManager.getInstance();
            SAMLSSOServiceProviderDO spDO = spConfigManager.getServiceProvider(authReqDTO.getIssuer());
            if (spDO == null) {
                IdentityPersistenceManager persistenceManager = IdentityPersistenceManager.getPersistanceManager();
                spDO = persistenceManager.getServiceProvider((Registry)AnonymousSessionUtil.getSystemRegistryByUserName((RegistryService)SAMLSSOUtil.getRegistryService(), (RealmService)SAMLSSOUtil.getRealmService(), (String)authReqDTO.getUsername()), authReqDTO.getIssuer());
            }
            if (spDO == null) {
                return false;
            }
            if (authReqDTO.getAssertionConsumerURL() == null) {
                authReqDTO.setAssertionConsumerURL(spDO.getAssertionConsumerUrl());
            }
            authReqDTO.setLoginPageURL(spDO.getLoginPageURL());
            authReqDTO.setCertAlias(spDO.getCertAlias());
            authReqDTO.setUseFullyQualifiedUsernameAsSubject(spDO.isUseFullyQualifiedUsername());
            authReqDTO.setDoSingleLogout(spDO.isDoSingleLogout());
            authReqDTO.setLogoutURL(spDO.getLogoutURL());
            authReqDTO.setDoSignAssertions(spDO.isDoSignAssertions());
            return true;
        }
        catch (Exception e) {
            String msg = "Error validating the issuer";
            log.error((Object)msg, (Throwable)e);
            throw new IdentityException(msg, (Throwable)e);
        }
    }
}

