/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.saml.builders;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.opensaml.saml2.core.LogoutRequest;
import org.opensaml.saml2.core.LogoutResponse;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.SessionIndex;
import org.opensaml.saml2.core.Status;
import org.opensaml.saml2.core.StatusCode;
import org.opensaml.saml2.core.StatusMessage;
import org.opensaml.saml2.core.impl.LogoutRequestBuilder;
import org.opensaml.saml2.core.impl.LogoutResponseBuilder;
import org.opensaml.saml2.core.impl.NameIDBuilder;
import org.opensaml.saml2.core.impl.SessionIndexBuilder;
import org.opensaml.saml2.core.impl.StatusBuilder;
import org.opensaml.saml2.core.impl.StatusCodeBuilder;
import org.opensaml.saml2.core.impl.StatusMessageBuilder;
import org.wso2.carbon.identity.sso.saml.util.SAMLSSOUtil;

public class SingleLogoutMessageBuilder {
    private static Log log = LogFactory.getLog(SingleLogoutMessageBuilder.class);

    public LogoutRequest buildLogoutRequest(String subject, String sessionId, String reason) {
        LogoutRequest logoutReq = new LogoutRequestBuilder().buildObject();
        logoutReq.setID(SAMLSSOUtil.createID());
        DateTime issueInstant = new DateTime();
        logoutReq.setIssueInstant(issueInstant);
        logoutReq.setNotOnOrAfter(new DateTime(issueInstant.getMillis() + 300000L));
        NameID nameId = new NameIDBuilder().buildObject();
        nameId.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        nameId.setValue(subject);
        logoutReq.setNameID(nameId);
        SessionIndex sessionIndex = new SessionIndexBuilder().buildObject();
        sessionIndex.setSessionIndex(sessionId);
        logoutReq.getSessionIndexes().add(sessionIndex);
        logoutReq.setReason(reason);
        return logoutReq;
    }

    public LogoutResponse buildLogoutResponse(String id, String status, String statMsg) {
        LogoutResponse logoutResp = new LogoutResponseBuilder().buildObject();
        logoutResp.setID(SAMLSSOUtil.createID());
        logoutResp.setInResponseTo(id);
        logoutResp.setIssuer(SAMLSSOUtil.getIssuer());
        logoutResp.setStatus(this.buildStatus(status, statMsg));
        return logoutResp;
    }

    private Status buildStatus(String status, String statMsg) {
        Status stat = new StatusBuilder().buildObject();
        StatusCode statCode = new StatusCodeBuilder().buildObject();
        statCode.setValue(status);
        stat.setStatusCode(statCode);
        if (statMsg != null) {
            StatusMessage statMesssage = new StatusMessageBuilder().buildObject();
            statMesssage.setMessage(statMsg);
            stat.setStatusMessage(statMesssage);
        }
        return stat;
    }

    static {
        SAMLSSOUtil.doBootstrap();
    }
}

