/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.saml.builders;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.Status;
import org.opensaml.saml2.core.StatusCode;
import org.opensaml.saml2.core.StatusMessage;
import org.opensaml.saml2.core.impl.ResponseBuilder;
import org.opensaml.saml2.core.impl.StatusBuilder;
import org.opensaml.saml2.core.impl.StatusCodeBuilder;
import org.opensaml.saml2.core.impl.StatusMessageBuilder;
import org.wso2.carbon.identity.sso.saml.util.SAMLSSOUtil;

public class ErrorResponseBuilder {
    private static Log log = LogFactory.getLog(ErrorResponseBuilder.class);
    private Response response;

    public ErrorResponseBuilder() {
        ResponseBuilder responseBuilder = new ResponseBuilder();
        this.response = responseBuilder.buildObject();
    }

    public Response buildResponse(String inResponseToID, String status, String statMsg) {
        this.response.setIssuer(SAMLSSOUtil.getIssuer());
        this.response.setStatus(this.buildStatus(status, statMsg));
        this.response.setVersion(SAMLVersion.VERSION_20);
        this.response.setID(SAMLSSOUtil.createID());
        this.response.setInResponseTo(inResponseToID);
        this.response.setIssueInstant(new DateTime());
        return this.response;
    }

    private Status buildStatus(String status, String statMsg) {
        Status stat = new StatusBuilder().buildObject();
        StatusCode statCode = new StatusCodeBuilder().buildObject();
        statCode.setValue(status);
        stat.setStatusCode(statCode);
        if (statMsg != null) {
            StatusMessage statMesssage = new StatusMessageBuilder().buildObject();
            statMesssage.setMessage(statMsg);
            stat.setStatusMessage(statMesssage);
        }
        return stat;
    }

    static {
        SAMLSSOUtil.doBootstrap();
    }
}

