/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.saml.admin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.model.SAMLSSOServiceProviderDO;
import org.wso2.carbon.identity.core.persistence.IdentityPersistenceManager;
import org.wso2.carbon.identity.sso.saml.dto.SAMLSSOServiceProviderDTO;
import org.wso2.carbon.identity.sso.saml.dto.SAMLSSOServiceProviderInfoDTO;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class SAMLSSOConfigAdmin {
    private static Log log = LogFactory.getLog(SAMLSSOConfigAdmin.class);
    private UserRegistry registry;

    public SAMLSSOConfigAdmin(Registry userRegistry) {
        this.registry = (UserRegistry)userRegistry;
    }

    public boolean addRelyingPartyServiceProvider(SAMLSSOServiceProviderDTO serviceProviderDTO) throws IdentityException {
        SAMLSSOServiceProviderDO serviceProviderDO = new SAMLSSOServiceProviderDO();
        serviceProviderDO.setIssuer(serviceProviderDTO.getIssuer());
        serviceProviderDO.setAssertionConsumerUrl(serviceProviderDTO.getAssertionConsumerUrl());
        serviceProviderDO.setCertAlias(serviceProviderDTO.getCertAlias());
        serviceProviderDO.setUseFullyQualifiedUsername(serviceProviderDTO.isUseFullyQualifiedUsername());
        serviceProviderDO.setDoSingleLogout(serviceProviderDTO.isDoSingleLogout());
        serviceProviderDO.setLogoutURL(serviceProviderDTO.getLogoutURL());
        serviceProviderDO.setDoSignAssertions(serviceProviderDTO.isDoSignAssertions());
        IdentityPersistenceManager persistenceManager = IdentityPersistenceManager.getPersistanceManager();
        try {
            return persistenceManager.addServiceProvider((Registry)this.registry, serviceProviderDO);
        }
        catch (IdentityException e) {
            log.error((Object)"Error obtaining a registry for adding a new service provider", (Throwable)e);
            throw new IdentityException("Error obtaining a registry for adding a new service provider", (Throwable)e);
        }
    }

    public SAMLSSOServiceProviderInfoDTO getServiceProviders() throws IdentityException {
        SAMLSSOServiceProviderDTO[] serviceProviders = null;
        try {
            IdentityPersistenceManager persistenceManager = IdentityPersistenceManager.getPersistanceManager();
            SAMLSSOServiceProviderDO[] providersSet = persistenceManager.getServiceProviders((Registry)this.registry);
            serviceProviders = new SAMLSSOServiceProviderDTO[providersSet.length];
            for (int i = 0; i < providersSet.length; ++i) {
                SAMLSSOServiceProviderDO providerDO = providersSet[i];
                SAMLSSOServiceProviderDTO providerDTO = new SAMLSSOServiceProviderDTO();
                providerDTO.setIssuer(providerDO.getIssuer());
                providerDTO.setAssertionConsumerUrl(providerDO.getAssertionConsumerUrl());
                providerDTO.setCertAlias(providerDO.getCertAlias());
                serviceProviders[i] = providerDTO;
            }
        }
        catch (IdentityException e) {
            log.error((Object)"Error obtaining a registry intance for reading service provider list", (Throwable)e);
            throw new IdentityException("Error obtaining a registry intance for reading service provider list", (Throwable)e);
        }
        SAMLSSOServiceProviderInfoDTO serviceProviderInfoDTO = new SAMLSSOServiceProviderInfoDTO();
        serviceProviderInfoDTO.setServiceProviders(serviceProviders);
        if (this.registry.getTenantId() == 0) {
            serviceProviderInfoDTO.setTenantZero(true);
        }
        return serviceProviderInfoDTO;
    }

    public boolean removeServiceProvider(String issuer) throws IdentityException {
        try {
            IdentityPersistenceManager persistenceManager = IdentityPersistenceManager.getPersistanceManager();
            return persistenceManager.removeServiceProvider((Registry)this.registry, issuer);
        }
        catch (IdentityException e) {
            log.error((Object)"Error removing a Service Provider");
            throw new IdentityException("Error removing a Service Provider", (Throwable)e);
        }
    }

    private String dumpPubCert(ConfigurationContext configurationContext, byte[] cert, String uuid) {
        Hashtable<String, String> fileResourcesMap = null;
        String workdir = null;
        File pubCert = null;
        FileOutputStream outStream = null;
        String filePath = null;
        workdir = (String)configurationContext.getProperty("WORK_DIR");
        pubCert = new File(workdir + File.separator + "pub_certs");
        if (uuid == null) {
            uuid = String.valueOf((double)System.currentTimeMillis() + Math.random()) + ".cert";
        }
        if (!pubCert.exists()) {
            pubCert.mkdirs();
        }
        filePath = workdir + File.separator + "pub_certs" + File.separator + uuid;
        try {
            outStream = new FileOutputStream(filePath);
            ((OutputStream)outStream).write(cert);
            outStream.flush();
            ((OutputStream)outStream).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        fileResourcesMap = (Hashtable<String, String>)configurationContext.getProperty("file.resource.map");
        if (fileResourcesMap == null) {
            fileResourcesMap = new Hashtable<String, String>();
            configurationContext.setProperty("file.resource.map", fileResourcesMap);
        }
        fileResourcesMap.put(uuid, filePath);
        return "/filedownload?id=" + uuid;
    }

    private String getPubKeyFilePath() throws Exception {
        if (this.registry.resourceExists("/repository/identity/generated-key")) {
            Resource r = this.registry.get("/repository/identity/generated-key");
            String filePath = r.getProperty("pub-Key-file-path");
            this.verifyCertExistence(filePath, (byte[])r.getContent(), MessageContext.getCurrentMessageContext().getConfigurationContext());
            return filePath;
        }
        return null;
    }

    private void verifyCertExistence(String uuid, byte[] cert, ConfigurationContext configurationContext) {
        uuid = uuid.substring("/filedownload?id=".length(), uuid.length());
        String workDir = (String)configurationContext.getProperty("WORK_DIR");
        File pubCert = new File(workDir + File.separator + "pub_certs" + File.separator + uuid);
        if (pubCert.exists()) {
            Hashtable<String, File> fileResourcesMap = (Hashtable<String, File>)configurationContext.getProperty("file.resource.map");
            if (fileResourcesMap == null) {
                fileResourcesMap = new Hashtable<String, File>();
                configurationContext.setProperty("file.resource.map", fileResourcesMap);
            }
            if (fileResourcesMap.get(uuid) == null) {
                fileResourcesMap.put(uuid, pubCert);
            }
            return;
        }
        this.dumpPubCert(configurationContext, cert, uuid);
    }
}

