/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.registration.ui.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import javax.crypto.SecretKey;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.processor.EncryptedKeyProcessor;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.encryption.XMLCipher;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.core.util.CryptoUtil;

public class TokenDecrypter {
    private static final Log log = LogFactory.getLog(TokenDecrypter.class);

    public static Element decryptToken(String token) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(token.getBytes());
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Document doc = dbf.newDocumentBuilder().parse(bais);
        Element encryptedTokenElem = doc.getDocumentElement();
        return TokenDecrypter.decryptElement(encryptedTokenElem);
    }

    private static Element decryptElement(Element encryptedToken) throws Exception {
        ServerConfiguration serverConfig = ServerConfiguration.getInstance();
        PrivateKey key = null;
        String keyStoreFile = null;
        String privateKeyPass = null;
        String privateKeyAlias = null;
        String keyStorePass = null;
        String type = null;
        byte[] content = null;
        try {
            keyStoreFile = serverConfig.getFirstProperty("Security.KeyStore.Location");
            keyStorePass = serverConfig.getFirstProperty("Security.KeyStore.Password");
            type = serverConfig.getFirstProperty("Security.KeyStore.Type");
            privateKeyAlias = serverConfig.getFirstProperty("Security.KeyStore.KeyAlias");
            privateKeyPass = serverConfig.getFirstProperty("Security.KeyStore.KeyPassword");
            CryptoUtil.getDefaultCryptoUtil();
            content = TokenDecrypter.readBytesFromFile(keyStoreFile);
            KeyStore keyStore = KeyStore.getInstance(type);
            keyStore.load(new ByteArrayInputStream(content), keyStorePass.toCharArray());
            key = (PrivateKey)keyStore.getKey(privateKeyAlias, privateKeyPass.toCharArray());
            Element kiElem = (Element)encryptedToken.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo").item(0);
            Element encrKeyElem = (Element)kiElem.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey").item(0);
            EncryptedKeyProcessor encrKeyProcessor = new EncryptedKeyProcessor();
            encrKeyProcessor.handleEncryptedKey(encrKeyElem, key);
            SecretKey secretKey = WSSecurityUtil.prepareSecretKey((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc", (byte[])encrKeyProcessor.getDecryptedBytes());
            XMLCipher cipher = XMLCipher.getInstance();
            cipher.init(2, (Key)secretKey);
            Document doc = cipher.doFinal(encryptedToken.getOwnerDocument(), encryptedToken);
            return doc.getDocumentElement();
        }
        catch (Exception e) {
            log.error((Object)"error occured while decryptng the token", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readBytesFromFile(String filePath) throws IOException {
        byte[] bytes;
        FileInputStream inputStream = null;
        File file = new File(filePath);
        int numRead = 0;
        try {
            inputStream = new FileInputStream(file);
            long length = file.length();
            bytes = new byte[(int)length];
            for (int offset = 0; offset < bytes.length && (numRead = ((InputStream)inputStream).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
        }
        finally {
            if (inputStream != null) {
                ((InputStream)inputStream).close();
            }
        }
        return bytes;
    }
}

