/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.registration.ui.client;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.user.registration.stub.UserRegistrationAdminServiceStub;
import org.wso2.carbon.identity.user.registration.stub.dto.InfoCarDTO;
import org.wso2.carbon.identity.user.registration.stub.dto.OpenIDDTO;
import org.wso2.carbon.identity.user.registration.stub.dto.UserDTO;
import org.wso2.carbon.identity.user.registration.stub.dto.UserFieldDTO;

public class UserRegistrationClient {
    private UserRegistrationAdminServiceStub stub;
    private static final Log log = LogFactory.getLog(UserRegistrationClient.class);
    public static String USER_REGISTRATION_CLIENT_NAME = "org.wso2.carbon.identity.user.registration.ui.client.UserRegistrationClient";

    public UserRegistrationClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backendServerURL + "UserRegistrationAdminService";
        this.stub = new UserRegistrationAdminServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public String getRequiredFieldsForRegistration() throws AxisFault {
        UserFieldDTO[] userFields = null;
        StringBuffer buffer = null;
        try {
            buffer = new StringBuffer();
            userFields = this.stub.readUserFieldsForUserRegistration("http://schemas.xmlsoap.org/ws/2005/05/identity");
            buffer.append("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier ");
            if (userFields != null) {
                for (int i = 0; i < userFields.length; ++i) {
                    if (!userFields[i].getRequired()) continue;
                    buffer.append(userFields[i].getClaimUri() + " ");
                }
                return buffer.toString();
            }
        }
        catch (Exception e) {
            this.handleException("Error ouccured while reading user registration configurations from the backend service", e);
        }
        return "";
    }

    public String getOptionalFieldsForRegistration() throws AxisFault {
        UserFieldDTO[] userFields = null;
        StringBuffer buffer = null;
        try {
            buffer = new StringBuffer();
            userFields = this.stub.readUserFieldsForUserRegistration("http://schemas.xmlsoap.org/ws/2005/05/identity");
            if (userFields != null) {
                for (int i = 0; i < userFields.length; ++i) {
                    if (userFields[i].getRequired()) continue;
                    buffer.append(userFields[i].getClaimUri() + " ");
                }
                return buffer.toString();
            }
        }
        catch (Exception e) {
            this.handleException("Error ouccured while reading user registration configurations from the backend service", e);
        }
        return "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier ";
    }

    public void addUser(UserDTO user) throws AxisFault {
        try {
            this.stub.addUser(user);
        }
        catch (Exception e) {
            this.handleException("Error ouccured while adding a user at the backend service", e);
        }
    }

    public void addUserWithInfoCard(InfoCarDTO infoCard) throws AxisFault {
        try {
            this.stub.addUserWithInfoCard(infoCard);
        }
        catch (Exception e) {
            this.handleException("Error ouccured while adding users with an information card at the backend service", e);
        }
    }

    public void addUserWithOpenID(OpenIDDTO openID) throws AxisFault {
        try {
            this.stub.addUserWithOpenID(openID);
        }
        catch (Exception e) {
            this.handleException("Error ouccured while adding users with an OpenID at the backend service", e);
        }
    }

    public boolean isAddUserEnabled() throws AxisFault {
        try {
            return this.stub.isAddUserEnabled();
        }
        catch (Exception e) {
            this.handleException("Error ouccured while reading user registration support from the backend service", e);
            return false;
        }
    }

    public boolean isAddUserWithOpenIDEnabled() throws AxisFault {
        try {
            return this.stub.isAddUserWithInfoCardEnabled();
        }
        catch (Exception e) {
            this.handleException("Error ouccured while reading inforcard user registration support from the backend service", e);
            return false;
        }
    }

    public boolean isAddUserWithInfoCardEnabled() throws AxisFault {
        try {
            return this.stub.isAddUserWithOpenIDEnabled();
        }
        catch (Exception e) {
            this.handleException("Error ouccured while reading openid user registration support from the backend service", e);
            return false;
        }
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    public UserFieldDTO[] readUserFieldsForUserRegistration(String dialect) throws AxisFault {
        try {
            return this.stub.readUserFieldsForUserRegistration(dialect);
        }
        catch (Exception e) {
            this.handleException("Error retrieving UserFiledDTOs for the dialect" + dialect, e);
            return null;
        }
    }

    public UserFieldDTO[] getOrderedUserFields(UserFieldDTO[] userFields) throws Exception {
        Arrays.sort(userFields, new UserFieldComparator());
        return userFields;
    }

    class UserFieldComparator
    implements Comparator<UserFieldDTO> {
        UserFieldComparator() {
        }

        @Override
        public int compare(UserFieldDTO filed1, UserFieldDTO filed2) {
            if (filed1.getDisplayOrder() == 0) {
                filed1.setDisplayOrder(Integer.MAX_VALUE);
            }
            if (filed2.getDisplayOrder() == 0) {
                filed2.setDisplayOrder(Integer.MAX_VALUE);
            }
            if (filed1.getDisplayOrder() < filed2.getDisplayOrder()) {
                return -1;
            }
            if (filed1.getDisplayOrder() == filed2.getDisplayOrder()) {
                return 0;
            }
            if (filed1.getDisplayOrder() > filed2.getDisplayOrder()) {
                return 1;
            }
            return 0;
        }
    }
}

