/*
 * Decompiled with CFR 0.152.
 */
package com.google.step2.servlet;

import com.google.inject.Guice;
import com.google.inject.Module;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class GuiceServletContextListener
implements ServletContextListener {
    public static final String MODULES_ATTRIBUTE = "guice-modules";
    public static final String INJECTOR_ATTRIBUTE = "guice-injector";

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        context.removeAttribute(INJECTOR_ATTRIBUTE);
    }

    public void contextInitialized(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        ArrayList<Module> modules = new ArrayList<Module>();
        String moduleNames = context.getInitParameter(MODULES_ATTRIBUTE);
        if (moduleNames != null) {
            for (String moduleName : moduleNames.split(",")) {
                try {
                    modules.add((Module)Class.forName(moduleName.trim()).newInstance());
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        context.setAttribute(INJECTOR_ATTRIBUTE, (Object)Guice.createInjector(modules));
    }
}

