/*
 * Decompiled with CFR 0.152.
 */
package com.google.step2.discovery;

import com.google.step2.discovery.HostMeta;
import com.google.step2.discovery.HostMetaException;
import com.google.step2.discovery.HostMetaFetcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ParallelHostMetaFetcher
implements HostMetaFetcher {
    private final List<HostMetaFetcher> fetchers;
    private final ExecutorService executorService;
    private final long timeout;

    public ParallelHostMetaFetcher(ExecutorService executorService, Long timeout, HostMetaFetcher ... fetchers) {
        if (fetchers.length == 0) {
            throw new IllegalArgumentException("need to supply at least one HostMetaFetcher to ParallelHostMetaFetcher");
        }
        this.fetchers = Arrays.asList(fetchers);
        this.executorService = executorService;
        this.timeout = timeout;
    }

    @Override
    public HostMeta getHostMeta(String host) throws HostMetaException {
        ArrayList<FetcherThread> threads = new ArrayList<FetcherThread>(this.fetchers.size());
        for (HostMetaFetcher fetcher : this.fetchers) {
            threads.add(new FetcherThread(fetcher, host));
        }
        try {
            return (HostMeta)this.executorService.invokeAny(threads, this.timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new HostMetaException(e);
        }
        catch (ExecutionException e) {
            throw new HostMetaException("no fetcher found a host-meta for " + host, e);
        }
        catch (RejectedExecutionException e) {
            throw new HostMetaException("could not schedule threads for parallel fetching of host-meta for " + host, e);
        }
        catch (TimeoutException e) {
            throw new HostMetaException("none of the host-meta fetchers completed within " + this.timeout + " seconds for host " + host, e);
        }
    }

    private class FetcherThread
    implements Callable<HostMeta> {
        private final String host;
        private final HostMetaFetcher fetcher;

        public FetcherThread(HostMetaFetcher fetcher, String host) {
            this.fetcher = fetcher;
            this.host = host;
        }

        @Override
        public HostMeta call() throws HostMetaException {
            HostMeta hostMeta = this.fetcher.getHostMeta(this.host);
            if (hostMeta == null || 0 == hostMeta.getLinks().size() + hostMeta.getLinkPatterns().size()) {
                throw new HostMetaException("fetcher " + this.fetcher.getClass().getName() + " returned empty host-meta for " + this.host);
            }
            return hostMeta;
        }
    }
}

