/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.relyingparty.ui.openid.extensions;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.sreg.SRegRequest;
import org.openid4java.message.sreg.SRegResponse;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.relyingparty.stub.dto.ClaimDTO;
import org.wso2.carbon.identity.relyingparty.ui.openid.OpenIDAuthenticationRequest;
import org.wso2.carbon.identity.relyingparty.ui.openid.OpenIDAxAttribute;
import org.wso2.carbon.identity.relyingparty.ui.openid.extensions.OpenIDExtension;

public class OpenIDSimpleReg
implements OpenIDExtension {
    private AuthSuccess authSuccess;
    private static Log log = LogFactory.getLog(OpenIDSimpleReg.class);

    public OpenIDSimpleReg() {
    }

    public OpenIDSimpleReg(AuthSuccess authSuccess) {
        this.authSuccess = authSuccess;
    }

    @Override
    public MessageExtension getMessageExtension(OpenIDAuthenticationRequest request) throws IdentityException {
        SRegRequest sregReq = null;
        sregReq = SRegRequest.createFetchRequest();
        if (request.getRequiredClaims() != null && request.getRequiredClaims().size() > 0) {
            for (OpenIDAxAttribute requiredClaim : request.getRequiredClaims()) {
                if (!(requiredClaim instanceof String)) continue;
                sregReq.addAttribute((String)((Object)requiredClaim), true);
            }
        }
        if (request.getOptionalClaims() != null && request.getOptionalClaims().size() > 0) {
            for (OpenIDAxAttribute optionalClaim : request.getOptionalClaims()) {
                if (!(optionalClaim instanceof String)) continue;
                sregReq.addAttribute((String)((Object)optionalClaim), false);
            }
        }
        return sregReq;
    }

    @Override
    public void setSessionAttributes(List<ClaimDTO> claimList) throws IdentityException {
        try {
            SRegResponse sregResp = null;
            Iterator iterator = null;
            Map attributes = null;
            Map.Entry entry2 = null;
            if (this.authSuccess.hasExtension("http://openid.net/sreg/1.0")) {
                sregResp = (SRegResponse)this.authSuccess.getExtension("http://openid.net/sreg/1.0");
            } else if (this.authSuccess.hasExtension("http://openid.net/sreg/1.0")) {
                sregResp = (SRegResponse)this.authSuccess.getExtension("http://openid.net/sreg/1.0");
            } else if (this.authSuccess.hasExtension("http://openid.net/extensions/sreg/1.1")) {
                sregResp = (SRegResponse)this.authSuccess.getExtension("http://openid.net/extensions/sreg/1.1");
            }
            if (sregResp != null) {
                ClaimDTO claim = null;
                attributes = sregResp.getAttributes();
                for (Map.Entry entry2 : attributes.entrySet()) {
                    claim = new ClaimDTO();
                    claim.setClaimUri((String)entry2.getKey());
                    claim.setClaimValue((String)entry2.getValue());
                    claimList.add(claim);
                }
            }
        }
        catch (MessageException e) {
            log.error((Object)"Error while adding retrieved user attributes to the session in OpenIDSimpleReg", (Throwable)e);
            throw new IdentityException("Error while adding retrieved user attributes to the session in OpenIDSimpleReg", (Throwable)e);
        }
    }

    protected void setDefaultRequestParams(SRegRequest request) {
    }
}

