/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.relyingparty.ui.openid.extensions;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ax.FetchRequest;
import org.openid4java.message.ax.FetchResponse;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.relyingparty.stub.dto.ClaimDTO;
import org.wso2.carbon.identity.relyingparty.ui.openid.OpenIDAuthenticationRequest;
import org.wso2.carbon.identity.relyingparty.ui.openid.OpenIDAxAttribute;
import org.wso2.carbon.identity.relyingparty.ui.openid.extensions.OpenIDExtension;

public class OpenIDAttributeExchange
implements OpenIDExtension {
    private AuthSuccess authSuccess;
    private static Map<String, String> axMapping;
    private static Log log;

    public OpenIDAttributeExchange() {
    }

    public OpenIDAttributeExchange(AuthSuccess authSuccess) {
        this.authSuccess = authSuccess;
    }

    @Override
    public MessageExtension getMessageExtension(OpenIDAuthenticationRequest request) throws IdentityException {
        FetchRequest fetchReq = null;
        OpenIDAxAttribute attr = null;
        try {
            fetchReq = FetchRequest.createFetchRequest();
            if (request != null && request.getRequiredClaims() != null && request.getRequiredClaims().size() > 0) {
                for (OpenIDAxAttribute requiredClaim : request.getRequiredClaims()) {
                    if (!(requiredClaim instanceof OpenIDAxAttribute)) continue;
                    attr = requiredClaim;
                    fetchReq.addAttribute(attr.getAttributeName(), attr.getNamespace(), true);
                }
            }
            if (request != null && request.getOptionalClaims() != null && request.getOptionalClaims().size() > 0) {
                for (OpenIDAxAttribute optionalClaim : request.getOptionalClaims()) {
                    if (!(optionalClaim instanceof OpenIDAxAttribute)) continue;
                    attr = optionalClaim;
                    fetchReq.addAttribute(attr.getAttributeName(), attr.getNamespace(), false);
                }
            }
        }
        catch (MessageException e) {
            log.error((Object)"Error while creating the message extension for OpenIDAttributeExchange", (Throwable)e);
            throw new IdentityException("Error while creating the message extension for OpenIDAttributeExchange", (Throwable)e);
        }
        return fetchReq;
    }

    @Override
    public void setSessionAttributes(List<ClaimDTO> claimList) throws IdentityException {
        List aliases = null;
        List values = null;
        FetchResponse fetchReponse = null;
        Map attributeTypes = null;
        ClaimDTO claim = null;
        try {
            if (this.authSuccess.hasExtension("http://openid.net/srv/ax/1.0")) {
                fetchReponse = (FetchResponse)this.authSuccess.getExtension("http://openid.net/srv/ax/1.0");
                aliases = fetchReponse.getAttributeAliases();
                attributeTypes = fetchReponse.getAttributeTypes();
                for (Object alias : aliases) {
                    values = fetchReponse.getAttributeValues((String)alias);
                    if (values == null || values.isEmpty()) continue;
                    claim = new ClaimDTO();
                    claim.setClaimUri((String)attributeTypes.get(alias));
                    claim.setClaimValue((String)values.get(0));
                    claimList.add(claim);
                }
            } else if (this.authSuccess.hasExtension("http://openid.net/srv/ax/1.0")) {
                fetchReponse = (FetchResponse)this.authSuccess.getExtension("http://openid.net/srv/ax/1.0");
                aliases = fetchReponse.getAttributeAliases();
                attributeTypes = fetchReponse.getAttributeTypes();
                for (Object alias : aliases) {
                    values = fetchReponse.getAttributeValues((String)alias);
                    if (values == null || values.isEmpty()) continue;
                    claim = new ClaimDTO();
                    claim.setClaimUri((String)attributeTypes.get(alias));
                    claim.setClaimValue((String)values.get(0));
                    claimList.add(claim);
                }
            }
        }
        catch (MessageException e) {
            log.error((Object)"Error while adding retrieved user attributes to the session in OpenIDAttributeExchange", (Throwable)e);
            throw new IdentityException("Error while adding retrieved user attributes to the session in OpenIDAttributeExchange", (Throwable)e);
        }
    }

    static {
        log = LogFactory.getLog(OpenIDAttributeExchange.class);
    }
}

